<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_report_meta_boxes' ) ) {
	function urbango_listing_add_listing_report_meta_boxes() {
		
		// Report meta box section - begin
		
		$report_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'report',
				'title' => esc_html__( 'Report Section', 'urbango-listing' ),
				'name'  => 'listing_report_meta_box'
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_reported_item_info',
				'title'  => esc_html__( 'Item Information', 'urbango-listing' ),
				'parent' => $report_box
			)
		);
		
		$listing_items = urbango_listing_get_cpt_items( 'listing-item', array( 'post_status' => array( 'publish', 'pending', 'draft' ) ) );
		
		if ( ! empty( $listing_items ) ) {
			
			urbango_edge_create_meta_box_field(
				array(
					'name'    => 'edgtf_listing_reported_listing_item_id_meta',
					'type'    => 'select',
					'label'   => esc_html__( 'Reported Listing Item', 'urbango-listing' ),
					'options' => $listing_items,
					'parent'  => $report_box,
					'args'    => array(
						'select2' => true
					)
				)
			);
			
			urbango_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_listing_reported_listing_author_message_meta',
					'type'        => 'textarea',
					'label'       => esc_html__( 'Reported Listing Author Message', 'urbango-listing' ),
					'description' => esc_html__( 'Inside this field you will see the author message after resubmission reported listing item. If problems are solved then just change approve report option to NO.', 'urbango-listing' ),
					'parent'      => $report_box
				)
			);
		}
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_reported_user_info',
				'title'  => esc_html__( 'Reported Information', 'urbango-listing' ),
				'parent' => $report_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'    => 'edgtf_listing_reported_user_id_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Report by User', 'urbango-listing' ),
				'options' => urbango_listing_get_all_users( true ),
				'parent'  => $report_box,
				'args'    => array(
					'select2' => true
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_listing_reported_user_reported_message_meta',
				'type'   => 'textarea',
				'label'  => esc_html__( 'Reported Message', 'urbango-listing' ),
				'parent' => $report_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_listing_reported_disable_user_reported_message_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Reported Message', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will disable reported user message in the reported author dashboard panel', 'urbango-listing' ),
				'parent'        => $report_box
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_reported_admin_info',
				'title'  => esc_html__( 'Administrator Information', 'urbango-listing' ),
				'parent' => $report_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_reported_admin_message_meta',
				'type'        => 'textarea',
				'label'       => esc_html__( 'Administrator Message', 'urbango-listing' ),
				'description' => esc_html__( 'Fill additional message for author listing if report is approved', 'urbango-listing' ),
				'parent'      => $report_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_listing_reported_disable_admin_message_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Disable Administrator Message', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will disable admin message in the reported author dashboard panel', 'urbango-listing' ),
				'parent'        => $report_box
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_reported_action',
				'title'  => esc_html__( 'Action', 'urbango-listing' ),
				'parent' => $report_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_listing_reported_status_action_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Approve Report', 'urbango-listing' ),
				'description'   => esc_html__( 'Enabling this option will block this listing until the author corrects the problem', 'urbango-listing' ),
				'parent'        => $report_box
			)
		);
		
		// Report meta box section - end
		
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_listing_add_listing_report_meta_boxes', 1 );
}
