<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_package_profile_navigation_item' ) ) {
	function urbango_listing_add_package_profile_navigation_item( $navigation, $dashboard_url ) {
		
		$navigation['my-packages'] = array(
			'url'         => esc_url( add_query_arg( array( 'user-action' => 'my-packages' ), $dashboard_url ) ),
			'text'        => esc_html__( 'My Packages', 'urbango-listing' ),
			'user_action' => 'my-packages',
			'icon'        => 'my-packages',
			'font_icon'   => array( 'far fa-folder', 'font_awesome' )
		);
		
		return $navigation;
	}
	
	add_filter( 'urbango_membership_dashboard_navigation_pages', 'urbango_listing_add_package_profile_navigation_item', 10, 2 );
}

if ( ! function_exists( 'urbango_listing_add_package_profile_navigation_pages' ) ) {
	function urbango_listing_add_package_profile_navigation_pages( $page, $action ) {
		
		if ( $action == 'my-packages' ) {
			$package_params                = array();
			$package_params['my_packages'] = urbango_listing_get_user_packages_list();
			$package_params['package_url'] = urbango_listing_get_pricing_packages_page();
			
			$page = urbango_listing_get_module_template_part( 'cpt-package-profile', 'package', 'my-packages', '', $package_params, array(), false );
		}
		
		return $page;
	}
	
	add_filter( 'urbango_membership_dashboard_pages', 'urbango_listing_add_package_profile_navigation_pages', 10, 2 );
}
