<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_allow_package_cpt_for_meta_box_functions' ) ) {
	function urbango_listing_allow_package_cpt_for_meta_box_functions( $post_types ) {
		$post_types[] = 'package';

		return $post_types;
	}

	add_filter( 'urbango_edge_filter_meta_box_post_types_save', 'urbango_listing_allow_package_cpt_for_meta_box_functions' );
	add_filter( 'urbango_edge_filter_meta_box_post_types_remove', 'urbango_listing_allow_package_cpt_for_meta_box_functions' );
}

if ( ! function_exists( 'urbango_listing_register_package_custom_post_types' ) ) {
	function urbango_listing_register_package_custom_post_types( $cpt_classes ) {
		$cpt_class = array(
			'UrbanGoListing\CPT\Package\PackageRegister'
		);

		return array_merge( $cpt_classes, $cpt_class );
	}

	add_filter( 'urbango_listing_filter_register_custom_post_types', 'urbango_listing_register_package_custom_post_types' );
}

if ( ! function_exists( 'urbango_listing_enqueue_package_meta_box_styles' ) ) {
	function urbango_listing_enqueue_package_meta_box_styles() {
		global $post;

		if ( $post->post_type == 'package' ) {
			wp_enqueue_style( 'urbango-listing-jquery-ui', get_template_directory_uri() . '/framework/admin/assets/css/jquery-ui/jquery-ui.css' );
		}
	}

	add_action( 'urbango_edge_action_enqueue_meta_box_styles', 'urbango_listing_enqueue_package_meta_box_styles' );
}

if ( ! function_exists( 'urbango_listing_include_package_shortcodes_files' ) ) {
	/**
	 * Loads all shortcodes by going through all folders that are placed directly in shortcodes folder
	 */
	function urbango_listing_include_package_shortcodes_files() {
		foreach ( glob( URBANGO_LISTING_CPT_PATH . '/package/shortcodes/*/load.php' ) as $shortcode_load ) {
			include_once $shortcode_load;
		}
	}

	add_action( 'urbango_listing_action_include_shortcodes_file', 'urbango_listing_include_package_shortcodes_files' );
}

if ( ! function_exists( 'urbango_listing_users_packages_in_menu' ) ) {
	function urbango_listing_users_packages_in_menu() {
		add_submenu_page(
			'edit.php?post_type=package',
			esc_html__( 'Users Packages', 'urbango-listing' ),
			esc_html__( 'Users Packages', 'urbango-listing' ),
			'administrator',
			'users_packages',
			'urbango_listing_users_packages_admin_panel'
		);
	}

	add_action( 'admin_menu', 'urbango_listing_users_packages_in_menu' );
}

if ( ! function_exists( 'urbango_listing_users_packages_admin_panel' ) ) {
	function urbango_listing_users_packages_admin_panel() {
		$params = array();
		$orders = wc_get_orders(
			array(
				'limit' => '-1'
			)
		);

		$users_orders = array();

		if ( ! empty( $orders ) ) {
			foreach ( $orders as $order ) {
				$items = $order->get_items();

				foreach ( $items as $item ) {
					if ( is_a( $item, 'WC_Order_Item_Package' ) ) {
						$package_id                           = $item->get_product_id();
						$order_params                         = array();
						$order_params['order_id']             = $order->get_id();
						$order_params['order_package_name']   = get_the_title( $package_id );
						$order_params['order_date']           = gmdate( 'Y-m-d H:i:s', $order->get_date_created()->getOffsetTimestamp() );
						$order_params['order_price']          = get_post_meta( $package_id, 'edgtf_package_price_meta', true );
						$order_params['order_buyer_name']     = $order->get_billing_last_name() . ' ' . $order->get_billing_first_name();
						$order_params['order_buyer_email']    = $order->get_billing_email();
						$order_params['order_payment_method'] = $order->get_payment_method_title();
						$order_params['order_status']         = wc_get_order_status_name( $order->get_status() );
						$order_params['order_link']           = admin_url( 'post.php?post=' . $order->get_id() . '&action=edit' );
						$users_orders[]                       = $order_params;
					}
				}
			}
		}

		$params['users_orders'] = $users_orders;

		urbango_listing_get_module_template_part( 'cpt', 'package', 'admin/templates/users-packages', '', $params );
	}
}

if ( ! function_exists( 'urbango_listing_include_package_payment_class' ) ) {
	/**
	 * Function that includes package payment
	 */
	function urbango_listing_include_package_payment_class() {
		if ( urbango_listing_is_woocommerce_checkout_integration_installed() && urbango_listing_is_woocommerce_installed() ) {
			require_once 'payment/class-wc-product-package.php';
			require_once 'payment/class-wc-order-item-package.php';
			require_once 'payment/class-wc-order-item-package-store.php';
			require_once 'payment/class-wc-package-data-store-cpt.php';
		}
	}

	add_action( 'wp_loaded', 'urbango_listing_include_package_payment_class' );
}

if ( ! function_exists( 'urbango_listing_add_package_to_post_types_payment' ) ) {
	/**
	 * Function that add custom post type to list
	 */
	function urbango_listing_add_package_to_post_types_payment( $post_types ) {
		if ( urbango_listing_is_woocommerce_checkout_integration_installed() ) {
			$post_types[] = 'package';
		}

		return $post_types;
	}

	add_filter( 'urbango_checkout_integration_post_types', 'urbango_listing_add_package_to_post_types_payment', 100 );
}

if ( ! function_exists( 'urbango_listing_package_add_to_cart_action' ) ) {
	function urbango_listing_package_add_to_cart_action( $add_to_cart_url ) {
		$product_id        = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_REQUEST['add-to-cart'] ) );
		$quantity          = empty( $_REQUEST['quantity'] ) ? 1 : wc_stock_amount( $_REQUEST['quantity'] );
		$passed_validation = true;

		if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity ) !== false ) {

			if ( 'yes' === get_option( 'woocommerce_cart_redirect_after_add' ) ) {
				wc_add_to_cart_message( array( $product_id => $quantity ), true );
			}

			wp_safe_redirect( wc_get_cart_url() );
			exit;
		}
	}

	add_action( 'woocommerce_add_to_cart_handler_package', 'urbango_listing_package_add_to_cart_action', 10, 1 );
}

if ( ! function_exists( 'urbango_listing_get_pricing_packages_page' ) ) {
	function urbango_listing_get_pricing_packages_page() {
		$page_id = urbango_edge_options()->getOptionValue( 'packages_default_page' );
		$url     = ! empty( $page_id ) ? esc_url( get_the_permalink( $page_id ) ) : '';

		return $url;
	}

	add_filter( 'woocommerce_return_to_shop_redirect', 'urbango_listing_get_pricing_packages_page', 10 );
}

if ( ! function_exists( 'urbango_listing_set_notice_for_pricing_packages_page' ) ) {
	function urbango_listing_set_notice_for_pricing_packages_page() {
		$page_id = urbango_edge_options()->getOptionValue( 'packages_default_page' );

		if ( is_page( $page_id ) ) {
			add_action( 'urbango_edge_action_after_container_inner_open', 'wc_print_notices', 10 );
		}
	}

	add_action( 'wp', 'urbango_listing_set_notice_for_pricing_packages_page' );
}

if ( ! function_exists( 'urbango_listing_set_packages_page_body_class' ) ) {
	function urbango_listing_set_packages_page_body_class( $classes ) {
		$page_id = urbango_edge_options()->getOptionValue( 'packages_default_page' );

		if ( is_page( $page_id ) ) {
			$classes[] = 'edgtf-pricing-package-page';
		}

		return $classes;
	}

	add_filter( 'body_class', 'urbango_listing_set_packages_page_body_class' );
}

if ( ! function_exists( 'urbango_listing_package_woocommerce_auto_complete_order' ) ) {
	function urbango_listing_package_woocommerce_auto_complete_order( $order_id ) {
		$payment_autocomplete = urbango_edge_options()->getOptionValue( 'enable_payment_autocomplete' ) === 'yes';

		if ( $payment_autocomplete ) {
			if ( ! $order_id ) {
				return;
			}

			$order = wc_get_order( $order_id );
			$order->update_status( 'completed' );
		}
	}

	add_action( 'woocommerce_thankyou', 'urbango_listing_package_woocommerce_auto_complete_order' );
}

if ( ! function_exists( 'urbango_listing_set_user_meta_packages_list' ) ) {
	function urbango_listing_set_user_meta_packages_list( $order_id, $status_from, $status_to, $order ) {
		if ( $status_to === 'completed' ) {
			$items          = $order->get_items();
			$user_packages  = get_user_meta( $order->get_customer_id(), 'edgtf_user_packages', true );
			$package_exists = false;

			if ( ! isset( $user_packages ) || empty( $user_packages ) ) {
				$user_packages = array();
				$index         = 0;
			} else {
				end( $user_packages );         // move the internal pointer to the end of the array
				$index = key( $user_packages );
				reset( $user_packages );

				foreach ( $user_packages as $user_package ) {
					if ( $user_package['order_id'] == $order_id ) {
						$package_exists = true;
						break;
					}
				}
			}

			if ( ! $package_exists ) {
				foreach ( $items as $item ) {
					if ( is_a( $item, 'WC_Order_Item_Package' ) ) {
						$index ++;
						$package_id              = $item->get_product_id();
						$package                 = array();
						$package['post_type_id'] = $package_id;
						$package['order_id']     = $order_id;
						$user_packages[ $index ] = $package;
					}
				}

				update_user_meta( $order->get_customer_id(), 'edgtf_user_packages', $user_packages );
			}
		}
	}

	add_action( 'woocommerce_order_status_changed', 'urbango_listing_set_user_meta_packages_list', 10, 4 );
}

if ( ! function_exists( 'urbango_listing_get_user_packages_list' ) ) {
	function urbango_listing_get_user_packages_list() {
		$user_packages = get_user_meta( get_current_user_id(), 'edgtf_user_packages', true );

		return $user_packages;
	}
}

if ( ! function_exists( 'urbango_listing_get_user_package_item' ) ) {
	function urbango_listing_get_user_package_item( $package ) {
		$user_packages = urbango_listing_get_user_packages_list();

		if ( isset( $user_packages ) && ! empty( $user_packages ) ) {
			$package = $user_packages[ $package ];

			return $package;
		}

		return false;
	}
}

if ( ! function_exists( 'urbango_listing_get_user_current_package' ) ) {
	function urbango_listing_get_user_current_package() {
		$user_packages = urbango_listing_get_user_packages_list();
		$user_posts    = intval( count_user_posts( get_current_user_id(), 'listing-item' ) );
		$items         = 0;

		if ( is_array( $user_packages ) && count( $user_packages ) ) {
			foreach ( $user_packages as $key => $package ) {
				if ( ! urbango_listing_get_package_expired( $package ) ) {
					$package_id        = $package['post_type_id'];
					$package_unlimited = get_post_meta( $package_id, 'edgtf_package_unlimited_listings_meta', true );

					if ( $package_unlimited === 'yes' ) {
						return $key;
					}

					$available_items = get_post_meta( $package_id, 'edgtf_package_listings_included_meta', true );
					$items           += intval( $available_items );

					if ( $items > $user_posts ) {
						return $key;
					}
				}
			}
		}

		return false;
	}
}

if ( ! function_exists( 'urbango_listing_check_is_ads_allowed_for_user_current_package' ) ) {
	function urbango_listing_check_is_ads_allowed_for_user_current_package() {
		$user_package = urbango_listing_get_user_current_package();

		if ( is_array( $user_package ) && count( $user_package ) ) {
			foreach ( $user_package as $key => $package ) {
				if ( ! urbango_listing_get_package_expired( $package ) ) {
					$package_id          = $package['post_type_id'];
					$package_ads_allowed = get_post_meta( $package_id, 'edgtf_package_allow_listing_ads_meta', true );

					if ( $package_ads_allowed === 'no' ) {
						return false;
					}
				}
			}
		}

		return true;
	}
}

if ( ! function_exists( 'urbango_listing_calculate_package_price' ) ) {
	function urbango_listing_calculate_package_price( $id = '' ) {
		$id = $id !== '' ? $id : get_the_ID();

		$price = get_post_meta( $id, 'edgtf_package_price_meta', true );

		return $price;
	}
}

if ( ! function_exists( 'urbango_listing_get_package_expiration_date' ) ) {
	function urbango_listing_get_package_expiration_date( $package ) {
		$package_id       = $package['post_type_id'];
		$order_id         = $package['order_id'];
		$post_time        = get_post_time( 'U', true, $order_id );
		$package_duration = get_post_meta( $package_id, 'edgtf_package_duration_meta', true );
		$package_duration = ! empty( $package_duration ) ? (int) $package_duration : 12;
		$expiration_time  = strtotime( '+' . $package_duration . 'month', $post_time );

		return $expiration_time;
	}
}

if ( ! function_exists( 'urbango_listing_get_package_expired' ) ) {
	function urbango_listing_get_package_expired( $package ) {
		$current_time    = current_time( 'timestamp', 0 );
		$expiration_time = urbango_listing_get_package_expiration_date( $package );

		return $expiration_time < $current_time;
	}
}

if ( ! function_exists( 'urbango_listing_get_package_status' ) ) {
	function urbango_listing_get_package_status( $package ) {
		$package_id        = $package['post_type_id'];
		$package_unlimited = get_post_meta( $package_id, 'edgtf_package_unlimited_listings_meta', true );

		if ( $package_unlimited === 'yes' ) {
			if ( urbango_listing_get_package_expired( $package ) ) {
				return esc_html__( 'Expired', 'urbango-listing' );
			} else {
				return esc_html__( 'Active', 'urbango-listing' );
			}
		} else {
			$total_items     = get_post_meta( $package_id, 'edgtf_package_listings_included_meta', true );
			$used_items      = urbango_listing_get_items_with_package( $package );
			$items_remaining = $total_items - $used_items;

			if ( $items_remaining <= 0 ) {
				return esc_html__( 'All used', 'urbango-listing' );
			} else {
				if ( urbango_listing_get_package_expired( $package ) ) {
					return esc_html__( 'Expired', 'urbango-listing' );
				} else {
					return esc_html__( 'Active', 'urbango-listing' );
				}
			}
		}
	}
}

if ( ! function_exists( ( 'urbango_listing_get_items_with_package' ) ) ) {
	function urbango_listing_get_items_with_package( $package, $featured_only = false ) {
		$user            = wp_get_current_user();
		$number_of_items = 0;

		if ( ! empty( $user ) ) {
			$meta_query   = array();
			$meta_query[] = array(
				'key'   => 'edgtf_listing_package_meta',
				'value' => $package,
				'type'  => 'numeric'
			);

			if ( $featured_only ) {
				$meta_query[] = array(
					'key'   => 'edgtf_listing_is_featured_meta',
					'value' => 'yes'
				);
			}

			$query_array = array(
				'post_status' => array( 'publish', 'draft' ),
				'post_type'   => 'listing-item',
				'author'      => esc_attr( intval( $user->ID ) )
			);

			$query_array['meta_query'] = $meta_query;

			$query_results   = new \WP_Query( $query_array );
			$number_of_items = $query_results->post_count;
		}

		return $number_of_items;
	}
}

if ( ! function_exists( 'urbango_listing_get_package_info' ) ) {
	function urbango_listing_get_package_info( $package ) {
		$package_info = array();

		if ( ! empty( $package ) ) {
			$package_id = $package['post_type_id'];

			// Get name
			$package_name                 = get_the_title( $package_id );
			$package_info['package_name'] = $package_name;

			// Get items remaining
			$package_unlimited = get_post_meta( $package_id, 'edgtf_package_unlimited_listings_meta', true );
			if ( $package_unlimited === 'yes' ) {
				$items_included  = esc_html__( 'Unlimited', 'urbango-listing' );
				$items_remaining = esc_html__( 'Unlimited', 'urbango-listing' );
			} else {
				$total_items     = get_post_meta( $package_id, 'edgtf_package_listings_included_meta', true );
				$items_included  = $total_items;
				$used_items      = urbango_listing_get_items_with_package( $package );
				$items_remaining = $total_items - $used_items;
			}

			$package_info['items_included']  = $items_included;
			$package_info['items_remaining'] = $items_remaining;

			// Get featured included
			$featured_items_included                 = get_post_meta( $package_id, 'edgtf_package_featured_listings_included_meta', true );
			$package_info['featured_items_included'] = $featured_items_included !== '' ? $featured_items_included : 0;

			// Get featured remaining
			$used_featured_items                      = urbango_listing_get_items_with_package( $package, true );
			$featured_items_remaining                 = intval( $featured_items_included ) - $used_featured_items;
			$package_info['featured_items_remaining'] = $featured_items_remaining;

			// Get expiration time
			$package_info['expiration_date'] = urbango_listing_get_package_expiration_date( $package );

			// Get ads
			$ads_allowed                 = get_post_meta( $package_id, 'edgtf_package_allow_listing_ads_meta', true );
			$package_info['ads_allowed'] = $ads_allowed;
		}

		return $package_info;
	}
}

if ( ! function_exists( 'urbango_listing_check_if_user_has_featured_items' ) ) {
	function urbango_listing_check_if_user_has_featured_items() {
		$package             = urbango_listing_get_user_current_package();
		$have_featured_items = false;

		if ( ! empty( $package ) ) {
			$package_item = urbango_listing_get_user_package_item( $package );

			if ( ! empty( $package_item ) ) {
				$package_id = $package_item['post_type_id'];

				// Get featured included
				$featured_items_included = get_post_meta( $package_id, 'edgtf_package_featured_listings_included_meta', true );

				// Get featured remaining
				$used_featured_items      = urbango_listing_get_items_with_package( $package, true );
				$featured_items_remaining = intval( $featured_items_included ) - $used_featured_items;

				if ( $featured_items_remaining > 0 ) {
					$have_featured_items = true;
				}
			}
		}

		return $have_featured_items;
	}
}

if ( ! function_exists( 'urbango_listing_get_buy_form' ) ) {
	function urbango_listing_get_package_buy_form() {

		if ( urbango_listing_is_woocommerce_installed() && urbango_listing_is_woocommerce_checkout_integration_installed() ) {
			urbango_checkout_get_buy_form( array(), array( 'input_text' => esc_html__( 'Buy Package', 'urbango-listing' ) ) );
		}
	}
}
