<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_package_options_map' ) ) {
	function urbango_listing_add_package_options_map( $panel ) {
		
		$pages       = get_all_page_ids();
		$pages_array = array();
		foreach ( $pages as $page ) {
			if ( get_post_status( $page ) == 'publish' ) {
				$pages_array[ $page ] = get_the_title( $page );
			}
		}
		
		$panel_packages = urbango_edge_add_admin_panel(
			array(
				'name'  => 'panel_packages',
				'title' => esc_html__( 'Pricing Packages', 'urbango-listing' ),
				'page'  => $panel
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'enable_packages_necessity',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Pricing Package Necessity for Adding Listing Items', 'urbango-listing' ),
				'description'   => esc_html__( 'Enable this option in order to make packages necessary for adding listing items', 'urbango-listing' ),
				'parent'        => $panel_packages
			)
		);
		
		$enabled_package_container = urbango_edge_add_admin_container(
			array(
				'name'       => 'enabled_package',
				'parent'     => $panel_packages,
				'dependency' => array(
					'show' => array(
						'enable_packages_necessity' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'        => 'packages_default_page',
				'type'        => 'select',
				'label'       => esc_html__( 'Pricing Packages Page', 'urbango-listing' ),
				'description' => esc_html__( 'Choose a page to be default for displaying pricing packages. (You should add pricing package shortcode on that page)', 'urbango-listing' ),
				'options'     => $pages_array,
				'parent'      => $enabled_package_container,
				'args'        => array(
					'select2' => true
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'enable_payment_autocomplete',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Payment Autocomplete', 'urbango-listing' ),
				'description'   => esc_html__( 'Use this option if your are using non-card payment methods to enable autocomplete of user purchases', 'urbango-listing' ),
				'parent'        => $enabled_package_container
			)
		);
		
		// Additional options - begin
		
		do_action( 'urbango_listing_action_additional_package_options_map', $panel_packages );
		
		// Additional options - end
		
	}
	
	add_action( 'urbango_listing_action_additional_listing_before_options_map', 'urbango_listing_add_package_options_map' );
}
