<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_package_meta_boxes' ) ) {
	function urbango_listing_add_package_meta_boxes() {
		
		$general_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'package',
				'name'  => 'package_general_meta_box',
				'title' => esc_html__( 'Package General Section', 'urbango-listing' )
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'package_general_settings',
				'title'  => esc_html__( 'General Settings', 'urbango-listing' ),
				'parent' => $general_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_package_featured_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Featured Package', 'urbango-listing' ),
				'parent'        => $general_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_package_unlimited_listings_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Unlimited Listings', 'urbango-listing' ),
				'parent'        => $general_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'       => 'edgtf_package_listings_included_meta',
				'type'       => 'text',
				'label'      => esc_html__( 'Number of Listings Included', 'urbango-listing' ),
				'parent'     => $general_box,
				'args'       => array(
					'col_width' => 3
				),
				'dependency' => array(
					'hide' => array(
						'edgtf_package_unlimited_listings_meta' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_package_featured_listings_included_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Number of Featured Listings Included', 'urbango-listing' ),
				'parent' => $general_box,
				'args'   => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_package_price_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Package Price', 'urbango-listing' ),
				'parent' => $general_box,
				'args'   => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_package_duration_meta',
				'type'        => 'text',
				'default'     => '12',
				'label'       => esc_html__( 'Package Duration (months)', 'urbango-listing' ),
				'description' => esc_html__( 'Enter how many months the package lasts. Default is 12', 'urbango-listing' ),
				'parent'      => $general_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'package_additional_settings',
				'title'  => esc_html__( 'Additional Settings', 'urbango-listing' ),
				'parent' => $general_box
			)
		);
		
		urbango_edge_add_repeater_field(
			array(
				'name'        => 'edgtf_package_additional_info_meta',
				'button_text' => '',
				'parent'      => $general_box,
				'fields'      => array(
					array(
						'name'      => 'label',
						'type'      => 'text',
						'label'     => esc_html__( 'Label', 'urbango-listing' ),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'value',
						'type'      => 'text',
						'label'     => esc_html__( 'Value', 'urbango-listing' ),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'checked',
						'type'      => 'select',
						'label'     => esc_html__( 'Checked', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					)
				)
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'package_advance_settings',
				'title'  => esc_html__( 'Advance Settings', 'urbango-listing' ),
				'parent' => $general_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_package_allow_listing_ads_meta',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Allow Listing Ads', 'urbango-listing' ),
				'description'   => esc_html__( 'Listing Ads are allowed for this package', 'urbango-listing' ),
				'parent'        => $general_box
			)
		);
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_listing_add_package_meta_boxes', 1 );
}
