<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'UrbanGoListingAddListing' ) && class_exists( 'UrbanGoEdgeClassWidget' ) ) {
	class UrbanGoListingAddListing extends UrbanGoEdgeClassWidget {
		
		public function __construct() {
			parent::__construct(
				'edgtf_add_listing',
				esc_html__( 'UrbanGo Add Listing', 'urbango-listing' ),
				array( 'description' => esc_html__( 'Display a opener for leading user to add listing page', 'urbango-listing' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'        => 'textfield',
					'name'        => 'widget_margin',
					'title'       => esc_html__( 'Margin', 'urbango-listing' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'urbango-listing' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'widget_text',
					'title' => esc_html__( 'Widget Text', 'urbango-listing' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$styles = array();
			
			if ( $instance['widget_margin'] !== '' ) {
				$styles[] = 'margin: ' . $instance['widget_margin'];
			}
			
			$widget_text = ! empty( $instance['widget_text']) ? esc_html( $instance['widget_text'] ) : esc_html__( 'Add listing', 'urbango-listing' );
			
			$custom_class = 'edgtf-add-listing-button';
			if ( is_user_logged_in() && urbango_listing_is_membership_plugin_installed() ) {
				$link    = urbango_membership_get_dashboard_page_url();
				$package = urbango_listing_check_is_package_available();
				
				//strongly false because of the 0 key for packages
				if ( $package !== false ) {
					$link = esc_url( add_query_arg( array( 'user-action' => 'add-listing' ), $link ) );
				} else {
					$link = urbango_listing_get_pricing_packages_page();
				}
				
				$custom_class .= ' edgtf-user-logged-in';
			} else {
				$link         = '#';
				$custom_class .= ' edgtf-login-opener';
			}
			?>
			<div class="edgtf-add-listing-widget" <?php urbango_edge_inline_style( $styles ); ?>>
				<a itemprop="url" class="<?php echo esc_attr( $custom_class ); ?>" href="<?php echo esc_url( $link ); ?>">
					<?php echo urbango_edge_icon_collections()->renderIcon( 'far fa-plus-square', 'font_awesome', array( 'icon_attributes' => array( 'class' => 'edgtf-alw-icon' ) ) ); ?>
					<span class="edgtf-alw-text"><?php echo esc_html( $widget_text ); ?></span>
				</a>
	        </div>
			<?php
		}
	}
}
