<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! empty( $terms_meta ) ) {
	foreach ( $terms_meta as $term_meta ) {
		if ( ! empty( $term_meta ) ) {
			$term = isset( $is_term_meta ) && $is_term_meta ? get_term( $term_meta, 'listing-' . $taxonomy ) : $term_meta;
			
			if ( is_object( $term ) ) {
				$term_id = $term->term_id;
				
				$term_custom_icon = get_term_meta( $term_id, 'edgtf_listing_' . esc_attr( $taxonomy ) . '_icon_meta', true );
				$term_svg_icon    = get_term_meta( $term_id, 'edgtf_listing_' . esc_attr( $taxonomy ) . '_svg_icon_meta', true );
				
				$term_icon = '';
				if ( ! empty( $term_custom_icon ) ) {
					$term_icon = $term_custom_icon;
				}
				
				if ( ! empty( $term_svg_icon ) ) {
					$term_icon = $term_svg_icon;
				}
				
				$item_class = ! empty( $term_icon ) ? 'edgtf-is-icon' : 'edgtf-without-icon';
				?>
				<a itemprop="url" class="edgtf-ls-<?php echo esc_attr( $taxonomy ); ?> <?php echo esc_attr( $item_class ); ?>" href="<?php echo esc_url( get_term_link( $term_id ) ); ?>">
					<?php if ( ! empty( $term_svg_icon ) ) {
						echo stripslashes( preg_replace( '/<script\b[^>]*>(.*?)<\/script>/is', '', $term_icon ) );
					} else if ( ! empty( $term_icon ) ) {
						echo wp_get_attachment_image( $term_icon );
					} ?>
					<span class="edgtf-ls-<?php echo esc_attr( $taxonomy ); ?>-label"><?php echo esc_html( $term->name ); ?></span>
				</a>
			<?php }
		}
	}
}
?>