<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$gallery_images_meta = get_post_meta( get_the_ID(), 'edgtf_listing_single_gallery_images_meta', true );

if ( ! empty( $gallery_images_meta ) ) {
	$gallery_images_count = count( explode( ',', $gallery_images_meta ) );
	$gallery_slider_class = 'edgtf-ls-gallery-single-image';
	$gallery_slider_data  = array();

	if ( $gallery_images_count > 1 ) {
		$gallery_slider_class = 'edgtf-owl-slider';
		
		$gallery_slider_data  = array(
			'data-number-of-items'             => '3',
			'data-enable-autoplay-hover-pause' => 'no',
			'data-slider-speed'                => '4000',
			'data-slider-margin'               => '5',
			'data-enable-auto-width'           => 'yes',
			'data-enable-navigation'           => 'no'
		);
	}
	?>
	<div class="edgtf-ls-gallery-images <?php echo esc_attr( $gallery_slider_class ); ?>" <?php echo urbango_edge_get_inline_attrs( $gallery_slider_data ); ?>>
		<?php
		$images = explode( ',', $gallery_images_meta );
		
		if ( ! empty( $images ) ) {
			for ( $i = 0; $i < count( $images ); $i ++ ) {
				if ( isset( $images[ $i ] ) ) {
					$image_url     = wp_get_attachment_url( $images[ $i ] );
					$holder_styles = 'background-image: url(' . esc_url( $image_url ) . ')';
					?>
					<div class="edgtf-ls-gallery-image" <?php echo urbango_edge_get_inline_style( $holder_styles ); ?>>
						<a href="<?php echo esc_url( $image_url ); ?>" data-rel="prettyPhoto[listing_single_gallery]">
							<?php echo wp_get_attachment_image( $images[ $i ], 'full', false, array( 'loading' => 'eager' ) ); ?>
						</a>
					</div>
				<?php }
			}
		} ?>
	</div>
<?php } ?>