<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$terms_meta = wp_get_post_terms( get_the_ID(), 'listing-category' );

if ( ! empty( $terms_meta ) ) { ?>
	<div class="edgtf-ls-categories">
		<?php
		$only_parent = urbango_edge_options()->getOptionValue( 'listing_single_show_only_parent_category' ) === 'yes';
		
		if ( $only_parent ) {
			foreach ( $terms_meta as $id => $term ) {
				if ( $term->parent !== 0 ) {
					unset( $terms_meta[ $id ] );
				}
			}
		}
		
		$params = array(
			'terms_meta'   => $terms_meta,
			'taxonomy'     => 'category',
			'is_term_meta' => false
		);
		
		urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/taxonomy-item', '', $params );
		?>
	</div>
<?php } ?>