<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$business_hours_meta           = get_post_meta( get_the_ID(), 'edgtf_listing_single_business_hours_meta', true );
$business_hours_time_zone_meta = get_post_meta( get_the_ID(), 'edgtf_listing_single_business_hours_time_zone_meta', true );

if ( ! empty( $business_hours_meta ) && is_array( $business_hours_meta ) ) {
	if ( ! empty( $business_hours_time_zone_meta ) ) {
		date_default_timezone_set( urbango_listing_get_date_time_zone_name_by_id( intval( $business_hours_time_zone_meta ) ) );
	} else {
		date_default_timezone_set( 'Europe/Belgrade' );
	}
	?>
	<div class="edgtf-ls-business-hours">
		<?php
		$current_date = getdate();
		
		if ( ! empty( $current_date ) && is_array( $current_date ) ) {
			$current_time_h = $current_date['hours'];
			$current_time_m = $current_date['minutes'];
			?>
			<div class="edgtf-ls-bg-notice">
				<?php foreach ( $business_hours_meta as $business_hour ) {
					if ( ucwords( $business_hour['day'] ) === $current_date['weekday'] ) {
						
						$open_time       = $business_hour['open_time'];
						$open_time_is_am = false;
						$open_time_is_pm = false;
						
						if ( strpos( $open_time, 'pm' ) !== false ) {
							$open_time_is_pm = true;
							$clean_open_time = explode( ':', str_replace( 'pm', '', $open_time ) );
							
							$open_time_h = intval( $clean_open_time[0] ) + 12; // To increase time format because of $current_date variable
							$open_time_m = intval( $clean_open_time[1] );
						} else {
							$open_time_is_am = true;
							$clean_open_time = explode( ':', str_replace( 'am', '', $open_time ) );
							
							$open_time_h = intval( $clean_open_time[0] );
							$open_time_m = intval( $clean_open_time[1] );
						}
						
						$end_time       = $business_hour['end_time'];
						$end_time_is_am = false;
						$end_time_is_pm = false;
						
						if ( strpos( $end_time, 'pm' ) !== false ) {
							$end_time_is_pm = true;
							$clean_end_time = explode( ':', str_replace( 'pm', '', $end_time ) );
							
							$end_time_h = intval( $clean_end_time[0] ) + 12; // To increase time format because of $current_date variable
							$end_time_m = intval( $clean_end_time[1] );
						} else {
							$end_time_is_am = true;
							$clean_end_time = explode( ':', str_replace( 'am', '', $end_time ) );
							
							$end_time_h = intval( $clean_end_time[0] );
							$end_time_m = intval( $clean_end_time[1] );
						}
						
						if ( $business_hour['24h_open'] === 'yes' ) {
							$is_closed = false;
						} else if ( $business_hour['closed'] === 'yes' ) {
							$is_closed = true;
						} else if ( $current_time_h >= $open_time_h && $current_time_h <= $end_time_h ) {
							$is_closed = false;
							
							if ( $current_time_h === $open_time_h && $current_time_m < $open_time_m ) {
								$is_closed = true;
							} else if ( $current_time_h === $end_time_h && $current_time_m > $end_time_m ) {
								$is_closed = true;
							}
						} else if ( ( $current_time_h >= $open_time_h || $current_time_h <= $end_time_h ) && $open_time_is_pm && $end_time_is_am ) {
							$is_closed = false;
							
							if ( $current_time_h === $open_time_h && $current_time_m < $open_time_m ) {
								$is_closed = true;
							} else if ( $current_time_h === $end_time_h && $current_time_m > $open_time_m ) {
								$is_closed = true;
							}
						} else {
							$is_closed = true;
						}
						
						$notice       = $is_closed ? esc_html__( 'Closed now', 'urbango-listing' ) : esc_html__( 'Open now', 'urbango-listing' );
						$notice_class = $is_closed ? 'edgtf-ls-bg-closed' : '';
						
						urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title_tag' => 'h5', 'title' => $notice, 'custom_class' => $notice_class ) );
					}
				} ?>
			</div>
		<?php }	?>
		<div class="edgtf-ls-bg-items">
			<?php $days = urbango_listing_get_weekend_days(); ?>
			<?php foreach ( $business_hours_meta as $business_hour ) { ?>
				<div class="edgtf-ls-bg-item">
					<?php
					$day = '';
					if ( array_key_exists( $business_hour['day'], $days) && isset( $days[$business_hour['day']] ) ) {
						$day = $days[$business_hour['day']];
					}
					?>
					<span class="edgtf-ls-bg-day"><?php echo esc_html( $day ); ?></span>
					<span class="edgtf-ls-bg-time">
						<?php if ( $business_hour['24h_open'] === 'yes' ) { ?>
							<span class="edgtf-ls-bg-24h"><?php esc_html_e( '24h open', 'urbango-listing' ); ?></span>
						<?php } else if ( $business_hour['closed'] === 'yes' ) { ?>
							<span class="edgtf-ls-bg-closed"><?php esc_html_e( 'Closed', 'urbango-listing' ); ?></span>
						<?php } else { ?>
							<span class="edgtf-ls-bg-open"><?php echo esc_html( $business_hour['open_time'] ); ?></span>
							<span class="edgtf-ls-bg-separator"><?php esc_html_e( '-', 'urbango-listing' ); ?></span>
							<span class="edgtf-ls-bg-close"><?php echo esc_html( $business_hour['end_time'] ); ?></span>
						<?php } ?>
					</span>
				</div>
			<?php } ?>
		</div>
		<div class="edgtf-ls-bg-local-time">
			<span><?php echo sprintf( esc_html__( 'Local time %s', 'urbango-listing' ), date( 'g:ia', time() ) ); ?></span>
		</div>
	</div>
<?php } ?>