<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$page_id = get_the_ID();

$included_terms_meta = array_filter( (array) get_post_meta( $page_id, 'edgtf_listing_single_included_amenities_meta', true ) );
$excluded_terms_meta = array_filter( (array) get_post_meta( $page_id, 'edgtf_listing_single_excluded_amenities_meta', true ) );

if ( ! empty( $included_terms_meta ) || ! empty( $excluded_terms_meta ) ) { ?>
    <div class="edgtf-ls-amenities">
        <?php
        urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/parts-title', '', array( 'title' => esc_attr__( 'Amenities', 'urbango-listing' ) ) );

        $included_terms = ! empty( $included_terms_meta ) ? $included_terms_meta : '';
        $excluded_terms = ! empty( $excluded_terms_meta ) ? $excluded_terms_meta : '';

        $params = array(
            'terms_meta'   => array(
                'included' => $included_terms,
                'excluded' => $excluded_terms
            ),
            'taxonomy'     => 'amenity',
            'is_term_meta' => true
        );
        ?>
        <div class="edgtf-ls-amenities-items">
            <?php urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/taxonomy-item', 'combined', $params ); ?>
        </div>
    </div>
<?php } ?>