<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$title_logo_meta = get_post_meta( get_the_ID(), 'edgtf_listing_single_title_logo_meta', true );
$title_classes   = ! empty( $title_logo_meta ) ? 'edgtf-ls-title-has-logo' : '';

?>
<div class="edgtf-ls-gallery">
	<?php
	// Get item gallery part
	urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/gallery' );
	?>
</div>
<div class="edgtf-ls-title-area-wrapper <?php echo esc_attr( $title_classes ); ?>">
	<div class="edgtf-grid">
		<div class="edgtf-ls-title-area">
			<div class="edgtf-ls-title-left-area">
				<?php
				// Get item logo part
				urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/logo' );
				?>
				<div class="edgtf-ls-title-content">
					<?php
					// Get item title part
					urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/title' );
					?>
					<div class="edgtf-ls-title-info">
						<?php
						// Get item ID part
						urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/item-id' );
						
						// Get item categories part
						urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/category' );
						?>
					</div>
				</div>
			</div>
			<div class="edgtf-ls-title-right-area">
				<div class="edgtf-ls-tra-section edgtf-ls-tra-section-one">
					<?php
					// Get item reviews count part
					urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/reviews-count' );
					
					// Get item price range part
					urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/price-range' );
					?>
				</div>
				<div class="edgtf-ls-tra-section edgtf-ls-tra-section-two">
					<?php
					// Get item wishlist link part
					urbango_listing_get_module_template_part( 'modules', 'wishlist', 'templates/wishlist-link' );
					
					// Get item social share part
					urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/social-share' );
					?>
				</div>
			</div>
		</div>
		<?php
		// Get item featured part
		urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/featured' );
		?>
	</div>
</div>
<div class="edgtf-grid edgtf-ls-content-area">
	<div class="edgtf-grid-row edgtf-grid-large-gutter">
		<div class="edgtf-grid-col-8">
			<?php
			// Get item content part
			urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/content' );
			
			// Get item amenities part
			urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/amenity' );
			
			// Get item tags part
			urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/tag' );
			
			// Get item reviews list and form part
			urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/reviews' );
			?>
		</div>
		<div class="edgtf-grid-col-4">
			<div class="edgtf-ls-sidebar">
				<?php
				// Get item location part
				urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/location' );
				
				// Get item open table part
				urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/open-table' );
				
				// Get item additional info part
				urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/additional-info' );
				
				// Get item ads part
				urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/parts/ads' );
				?>
			</div>
		</div>
	</div>
</div>