<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$item_classes = array();
$item_layout  = '';

if ( urbango_listing_check_is_item_reported( get_the_ID() ) ) {
	$item_classes[] = 'edgtf-reported-item';
	$item_layout    = 'reported';
}

$item_is_featured = get_post_meta( get_the_ID(), 'edgtf_listing_is_featured_meta', true );
if ( $item_is_featured === 'yes' ) {
	$item_classes[] = 'edgtf-featured-item';
}
?>
<div class="edgtf-full-width">
	<div class="edgtf-full-width-inner">
		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			<div class="edgtf-listing-single-holder <?php echo esc_attr( implode( ' ', $item_classes ) ); ?>">
				<?php if ( post_password_required() ) { ?>
					<div class="edgtf-grid">
						<?php echo get_the_password_form(); ?>
					</div>
				<?php } else {
					// Get single content part
					urbango_listing_get_module_template_part( 'cpt', 'listing', 'templates/single/item', $item_layout );
				} ?>
			</div>
		<?php endwhile; endif;
		
		wp_reset_postdata();
		?>
	</div>
</div>