(function ($) {
	'use strict';
	
	var edgtfOT = {};
	edgtf.modules.edgtfOT = edgtfOT;
	
	edgtfOT.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		initedgtfOTParams();
		reInitListingGalleryPrettyPhoto();
	}
	
	function initedgtfOTParams() {
		var holder = $('.edgtf-ls-open-table');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					selectInputFields = thisHolder.find('select');
				
				if (selectInputFields.length) {
					selectInputFields.each(function () {
						$(this).select2();
					});
				}
			});
		}
	}

	function reInitListingGalleryPrettyPhoto() {
		var gallerySlider = $( '.edgtf-ls-gallery-images.edgtf-owl-slider' );

		if ( gallerySlider.length ) {
			gallerySlider.on(
				'changed.owl.carousel',
				function () {
					edgtf.modules.common.edgtfPrettyPhoto();
				}
			);
		}
	}
	
})(jQuery);