<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_map_with_listings_shortcode' ) ) {
	function urbango_listing_add_map_with_listings_shortcode( $shortcodes_class_name ) {
		$shortcodes = array(
			'UrbanGoListing\CPT\Shortcodes\Listing\MapWithListings'
		);
		
		$shortcodes_class_name = array_merge( $shortcodes_class_name, $shortcodes );
		
		return $shortcodes_class_name;
	}
	
	add_filter( 'urbango_listing_filter_add_vc_shortcode', 'urbango_listing_add_map_with_listings_shortcode' );
}

if ( ! function_exists( 'urbango_listing_set_map_with_listings_icon_class_name_for_vc_shortcodes' ) ) {
	/**
	 * Function that set custom icon class name for this shortcode to set our icon for Visual Composer shortcodes panel
	 */
	function urbango_listing_set_map_with_listings_icon_class_name_for_vc_shortcodes( $shortcodes_icon_class_array ) {
		$shortcodes_icon_class_array[] = '.icon-wpb-map-with-listings';
		
		return $shortcodes_icon_class_array;
	}
	
	add_filter( 'urbango_listing_filter_add_vc_shortcodes_custom_icon_class', 'urbango_listing_set_map_with_listings_icon_class_name_for_vc_shortcodes' );
}
