<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<?php if ( $enable_location === 'yes' ) {
	$holder_classes = $location_field_type === 'places' && is_ssl() ? 'edgtf-ls-has-geo-location' : '';
	?>
    <div class="edgtf-ls-form-section edgtf-ls-form-location <?php echo esc_attr( $holder_classes ); ?>">
		<?php if ( $location_field_type === 'places' ) { ?>
            <input type="text" id="edgtf-ls-form-location-id" name="edgtf-search-location" value="" placeholder="<?php esc_attr_e( 'Fill your location...', 'urbango-listing' ); ?>" autocomplete="off"/>
            <a class="edgtf-ls-places-link edgtf-ls-places-reset" href="#">
				<?php echo urbango_edge_icon_collections()->renderIcon( 'edgtf-ls-places-icon icon_close', 'font_elegant' ); ?>
            </a>
			<?php if ( is_ssl() ) { ?>
                <a class="edgtf-ls-places-link edgtf-ls-places-geo" href="#">
					<?php echo urbango_edge_icon_collections()->renderIcon( 'edgtf-ls-places-icon fas fa-crosshairs', 'font_awesome' ); ?>
                    <span class="edgtf-ls-places-notice"><?php esc_html_e( 'Locate me', 'urbango-listing' ); ?></span>
                </a>
			<?php } ?>
		<?php } else {
			$locations = urbango_listing_get_cpt_taxonomy_items( 'location', false );

			if ( ! empty( $locations ) ) { ?>
                <select name="edgtf-search-location">
                    <option value=""><?php esc_html_e( 'All Locations', 'urbango-listing' ); ?></option>
					<?php foreach ( $locations as $key => $name ) { ?>
                        <option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $name ); ?></option>
					<?php } ?>
                </select>
			<?php }
		} ?>
    </div>
<?php } ?>