<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$categories = urbango_listing_get_cpt_taxonomy_items( 'category', false, 'listing', true );
?>
<?php if ( $enable_category === 'yes' && ! empty( $categories ) ) { ?>
	<div class="edgtf-ls-form-section edgtf-ls-form-category">
		<select name="edgtf-search-category" class="edgtf-select-options-with-icons">
			<option value="" data-custom-image="<?php echo URBANGO_LISTING_ASSETS_URL_PATH . '/img/listing-all-categories.png'; ?>" data-custom-image-alt="<?php esc_attr_e( 'All Categories', 'urbango-listing' ); ?>"><?php esc_html_e( 'All Categories', 'urbango-listing' ); ?></option>
			<?php foreach ( $categories as $key => $name ) {
				$category_icon_id  = get_term_meta( $key, 'edgtf_listing_category_search_icon_meta', true );
				$category_icon_url = ! empty( $category_icon_id ) ? wp_get_attachment_image_url( $category_icon_id ) : '';
				$category_icon_alt = ! empty( $category_icon_id ) ? get_post_meta( $category_icon_id, '_wp_attachment_image_alt', true ) : '';
				?>
				<option value="<?php echo esc_attr( $key ); ?>" data-custom-image="<?php echo esc_url( $category_icon_url ); ?>" data-custom-image-alt="<?php echo esc_attr( $category_icon_alt ); ?>"><?php echo esc_html( $name ); ?></option>
			<?php } ?>
		</select>
	</div>
<?php } ?>