(function ($) {
	'use strict';
	
	var listingSearch = {};
	edgtf.modules.listingSearch = listingSearch;
	
	listingSearch.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		initListingSearchParams();
	}
	
	function initListingSearchParams() {
		var holder = $('.edgtf-listing-search-holder');
		
		if (holder.length) {
			holder.each(function () {
				var thisHolder = $(this),
					selectInput = thisHolder.find('.edgtf-ls-form-section select'),
					locationInput = thisHolder.find('.edgtf-ls-form-location input[type="text"]'),
					locationInputID = document.getElementById('edgtf-ls-form-location-id'),
					geoLocationResetLink = thisHolder.find('.edgtf-ls-places-reset'),
					geoLocationLink = thisHolder.find('.edgtf-ls-places-geo'),
					geoLocationLinkIcon = geoLocationLink.children('.edgtf-ls-places-icon');
				
				if (selectInput.length) {
					selectInput.each(function () {
						var thisSelectInput = $(this);
						
						if (thisSelectInput.hasClass('edgtf-select-options-with-icons')) {
							thisSelectInput.select2({
								templateResult: setNewSelectOptionValue
							});
						} else {
							thisSelectInput.select2();
						}
					});
				}
				
				if (locationInput.length) {
					edgtf.modules.listingMaps.edgtfGoogleMaps.createAutocompletePlaces(locationInputID);
				}
				
				geoLocationResetLink.on('click', function (e) {
					e.preventDefault();
					
					locationInput.val('');
					geoLocationResetLink.hide();
				});
				
				geoLocationLink.on('click', function (e) {
					e.preventDefault();
					
					if (typeof google === 'object' && typeof navigator === 'object') {
						geoLocationResetLink.show();
						edgtf.modules.listingMaps.edgtfGoogleMaps.centerOnCurrentLocation(true, locationInput, geoLocationLinkIcon);
					}
				});
			});
		}
	}
	
	function setNewSelectOptionValue(state) {
		if (!state.id) {
			return state.text;
		}
		
		var originalElement = state.element;
		
		if ($(originalElement).data('custom-image') === 'undefined' || $(originalElement).data('custom-image') === false || $(originalElement).data('custom-image') === '') {
			return state.text;
		}
		
		var $new_text = state.text === 'all' ? '' : state.text,
			$new_state = $('<span class="edgtf-select2-with-image"><img src="' + $(originalElement).data('custom-image') + '" alt="' + $(originalElement).data('custom-image-alt') + '"/>' + $new_text + '</span>');
		
		return $new_state;
	}
	
})(jQuery);