<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( $query_results->max_num_pages > 1 ) {
	$pages = $query_results->max_num_pages;
	$paged = $query_results->query['paged'];
	
	if ( $pages > 1 ) { ?>
		<div class="edgtf-ll-standard-pagination">
			<ul>
				<li class="edgtf-ll-pag-prev">
					<a href="#" data-paged="1"><span class="icon-arrows-left"></span></a>
				</li>
				<?php for ( $i = 1; $i <= $pages; $i ++ ) { ?>
					<?php
					$active_class = '';
					if ( $paged == $i ) {
						$active_class = 'edgtf-ll-pag-active';
					}
					?>
					<li class="edgtf-ll-pag-number <?php echo esc_attr( $active_class ); ?>">
						<a href="#" data-paged="<?php echo esc_attr( $i ); ?>"><?php echo esc_html( $i ); ?></a>
					</li>
				<?php } ?>
				<li class="edgtf-ll-pag-next">
					<a href="#" data-paged="2"><span class="icon-arrows-right"></span></a>
				</li>
			</ul>
		</div>
	<?php }
}
?>