<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-listing-list-holder <?php echo esc_attr( $holder_classes ); ?>" <?php echo wp_kses( $holder_data, array( 'data' ) ); ?>>
	<?php
	// Get map part
	urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'parts/map', '', $params, $additional_params );
	?>
	<div class="edgtf-listing-list-items-part">
		<?php
		// Get filter part
		urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'filter/holder', '', $params );
		?>
		<div class="edgtf-ll-inner edgtf-masonry-list-wrapper <?php echo esc_attr( $holder_inner_classes ); ?>">
			<div class="edgtf-masonry-grid-sizer"></div>
			<div class="edgtf-masonry-grid-gutter"></div>
			<?php
			if ( $query_results->have_posts() ):
				while ( $query_results->have_posts() ) : $query_results->the_post();
					// Get item content part
					urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'item', '', $params );
				endwhile;
			else:
				// Get posts not found part
				urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'parts/posts-not-found' );
			endif;
			
			wp_reset_postdata();
			?>
		</div>
		<?php
		// Get loading elements for pagination and filter part
		urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'pagination/loading-element' );
		
		// Get pagination part
		urbango_listing_get_module_template_part( 'cpt-listing', 'listing-list', 'pagination/' . $pagination_type, '', $params, $additional_params  );
		?>
	</div>
</div>