<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

// Disable filter section if filter type is empty (type can be taxonomy name or custom)
if ( ! isset( $filter_type ) && empty( $filter_type ) ) {
	return;
}

// Get terms value
if ( $field_type === 'text' ) {
	$terms = true;
} else if ( $filter_type === 'order-by' ) {
	$terms = urbango_listing_get_listing_list_query_order_by_array();
} else {
	$terms = urbango_listing_get_cpt_taxonomy_items( $filter_type, false );
}

// Get relation terms value
if ( is_tax( 'listing-category' ) && $filter_type !== 'order-by' ) {
	$relation_terms_meta = get_term_meta( get_queried_object_id(), 'edgtf_listing_category_relation_tags_meta', true );
	$relation_terms      = array();
	
	if ( ! empty( $relation_terms_meta ) ) {
		foreach ( $relation_terms_meta as $relation_term_id ) {
			$relation_terms[ $relation_term_id ] = urbango_listing_get_cpt_taxonomy_name_by_id( $relation_term_id );
		}
	}
	
	$terms = ! empty( $relation_terms ) ? $relation_terms : $terms;
}

// Disable filter section if terms is empty
if ( empty( $terms ) ) {
	return;
}

// Check is filter section allowed
$is_option_set        = ! empty( $value ) && $field_type !== 'text' && ! isset( $_GET['edgtf-listing-search'] );
$hide_active_filter   = isset( $hide_filter ) && $hide_filter === 'yes';

// Set default select value for filter when is not search page
$default_select_value = ! isset( $_GET['edgtf-listing-search'] ) ? $value : '';

if ( ! $is_option_set || ( $is_option_set && ! $hide_active_filter ) ) { ?>
	<div class="edgtf-filter-section edgtf-filter-section-<?php echo esc_attr( $filter_type ); ?>">
		<?php switch ( $field_type ) {
			case 'select':
			?>
				<div class="edgtf-fs-inner edgtf-fs-is-select2" data-type="<?php echo esc_attr( $filter_type ); ?>" data-default-<?php echo esc_attr( $filter_type ); ?>="<?php echo esc_attr( $default_select_value ); ?>" data-<?php echo esc_attr( $filter_type ); ?>="<?php echo esc_attr( $value ); ?>">
					<select name="edgtf-fs-<?php echo esc_attr( $filter_type ); ?>">
						<?php if ( ! empty( $default_label ) ) { ?>
							<option value=""><?php echo esc_html( $default_label ); ?></option>
						<?php } ?>
						<?php foreach ( $terms as $id => $name ) { ?>
							<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $value, $id ); ?>><?php echo esc_html( $name ); ?></option>
						<?php } ?>
					</select>
				</div>
			<?php
				break;
			case 'checkboxes':
			?>
				<div class="edgtf-fs-inner edgtf-fs-is-checkbox" data-type="<?php echo esc_attr( $filter_type ); ?>">
					<?php if ( ! empty( $default_label ) ) { ?>
						<h5 class="edgtf-fs-<?php echo esc_attr( $filter_type ); ?>-title"><?php echo esc_html( $default_label ); ?></h5>
					<?php } ?>
					<div class="edgtf-fs-cb-items">
						<?php foreach ( $terms as $id => $name ) {
							$cb_id      = strtolower( str_replace( ' ', '-', $name ) ) . '-' . $id;
							$cb_values  = ! empty( $value ) ? explode( ',', $value ) : '';
							$real_value = '';
							
							if ( ! empty( $cb_values ) ) {
								foreach ( $cb_values as $cb_value ) {
									if ( intval( $cb_value ) === $id ) {
										$real_value = intval( $cb_value );
									}
								}
							}
							?>
							<div class="edgtf-fs-cb-item">
								<input type="checkbox" id="<?php echo esc_attr( $cb_id ); ?>" name="edgtf-fs-cb-<?php echo esc_attr( $filter_type ); ?>[]" data-id="<?php echo esc_attr( $id ); ?>" value="" <?php checked( $real_value, $id ); ?> />
								<label for="<?php echo esc_attr( $cb_id ); ?>"><?php echo esc_html( $name ); ?></label>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php
				break;
			case 'text':
				?>
				<div class="edgtf-fs-inner edgtf-fs-is-text" data-type="<?php echo esc_attr( $filter_type ); ?>">
					<input type="text" name="edgtf-text-<?php echo esc_attr( $filter_type ); ?>" value="<?php echo esc_attr( $value ); ?>" placeholder="<?php echo esc_attr( $default_label ); ?>" />
				</div>
				<?php
				break;
			case 'places':
				$holder_classes = is_ssl() ? 'edgtf-fs-has-geo-location' : '';
				?>
				<div class="edgtf-fs-inner edgtf-fs-is-places <?php echo esc_attr( $holder_classes ); ?>" data-type="<?php echo esc_attr( $filter_type ); ?>">
					<input type="text" id="edgtf-fs-places-<?php echo esc_attr( $filter_type ); ?>" name="edgtf-fs-places-<?php echo esc_attr( $filter_type ); ?>" value="<?php echo esc_attr( $value ); ?>" placeholder="<?php echo esc_attr( $default_label ); ?>" autocomplete="off" />
					<a class="edgtf-fs-places-link edgtf-fs-places-reset" href="#">
						<?php echo urbango_edge_icon_collections()->renderIcon( 'edgtf-fs-places-icon icon_close', 'font_elegant' ); ?>
					</a>
					<?php if ( is_ssl() ) { ?>
						<a class="edgtf-fs-places-link edgtf-fs-places-geo" href="#">
							<?php echo urbango_edge_icon_collections()->renderIcon( 'edgtf-fs-places-icon fas fa-crosshairs', 'font_awesome' ); ?>
							<span class="edgtf-fs-places-notice"><?php esc_html_e( 'Locate me', 'urbango-listing' ); ?></span>
						</a>
						<div class="edgtf-fs-places-geo-radius" data-geo-location="">
							<span class="edgtf-range-slider-label"><?php esc_html_e( 'Near me', 'urbango-listing' ); ?></span>
							<div class="edgtf-range-slider" id="edgtf-range-slider-id"></div>
						</div>
					<?php } ?>
				</div>
				<?php
				break;
		} ?>
	</div>
<?php } ?>