<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$reset_button_class = '';
if ( isset( $_GET['edgtf-listing-search'] ) ) {
	$reset_button_class = ' edgtf-ll-filter-is-searched';
}
?>
<div class="edgtf-filter-section edgtf-filter-section-buttons">
	<div class="edgtf-fs-inner">
		<?php if ( urbango_listing_is_core_plugin_installed() ) {
			// Get search button
			echo urbango_edge_get_button_html( array(
				'custom_class' => 'edgtf-ll-filter-search',
				'html_type'    => 'button',
				'type'         => 'outline',
				'text'         => esc_html__( 'Filter Results', 'urbango-listing' )
			) );
			
			// Get save button
			echo urbango_edge_get_button_html( array(
				'custom_class' => 'edgtf-ll-filter-save',
				'html_type'    => 'button',
				'type'         => 'outline',
				'text'         => esc_html__( 'Save Search', 'urbango-listing' )
			) );
			
			// Get reset button
			echo urbango_edge_get_button_html( array(
				'custom_class' => 'edgtf-ll-filter-reset' . esc_attr( $reset_button_class ),
				'html_type'    => 'button',
				'type'         => 'outline',
				'text'         => esc_html__( 'Reset All', 'urbango-listing' )
			) );
		} ?>
		<span class="edgtf-filter-query-results"></span>
	</div>
</div>