<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$excerpt = strip_tags( get_user_meta( $author_id, 'description', true ) );

if ( ! isset( $excerpt_length ) || ( isset( $excerpt_length ) && $excerpt_length === '' ) ) {
	$excerpt_length = 44;
}

if ( ! empty( $excerpt ) && ! empty( $excerpt_length ) ) {
	$new_excerpt = ( $excerpt_length > 0 ) ? substr( $excerpt, 0, intval( $excerpt_length ) ) : $excerpt;
	?>
	<p itemprop="description" class="edgtf-al-excerpt"><?php echo esc_html( $new_excerpt ); ?></p>
<?php } ?>