<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_cpt_search_page_classes' ) ) {
	/**
	 * Adds listing cpt search page classes to the body
	 *
	 * @param $classes
	 *
	 * @return array
	 */
	function urbango_listing_add_listing_cpt_search_page_classes( $classes ) {
		
		if ( is_search() && isset( $_GET['edgtf-listing-search'] ) ) {
			$classes[] = 'urbango-listing-archive';
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'urbango_listing_add_listing_cpt_search_page_classes' );
}

if ( ! function_exists( 'urbango_listing_override_listing_search_template_path' ) ) {
	function urbango_listing_override_listing_search_template_path( $template_path ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$template_path = URBANGO_LISTING_CPT_PATH . '/';
		}
		
		return $template_path;
	}
	
	add_filter( 'urbango_edge_filter_edit_module_template_path', 'urbango_listing_override_listing_search_template_path' );
}

if ( ! function_exists( 'urbango_listing_override_listing_search_plugin' ) ) {
	function urbango_listing_override_listing_search_plugin( $plugin ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$plugin = true;
		}
		
		return $plugin;
	}
	
	add_filter( 'urbango_edge_filter_search_page_plugin_override', 'urbango_listing_override_listing_search_plugin' );
}

if ( ! function_exists( 'urbango_listing_override_listing_search_module' ) ) {
	function urbango_listing_override_listing_search_module( $module ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$module = 'listing';
		}
		
		return $module;
	}
	
	add_filter( 'urbango_edge_filter_search_page_module', 'urbango_listing_override_listing_search_module' );
}

if ( ! function_exists( 'urbango_listing_override_listing_search_path' ) ) {
	function urbango_listing_override_listing_search_path( $path ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$path = 'search';
		}
		
		return $path;
	}
	
	add_filter( 'urbango_edge_filter_search_page_path', 'urbango_listing_override_listing_search_path' );
}

if ( ! function_exists( 'urbango_listing_override_listing_search_page_content_holder' ) ) {
	function urbango_listing_override_listing_search_page_content_holder( $params ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$params['holder'] = 'edgtf-full-width';
			$params['inner']  = 'edgtf-full-width-inner';
		}
		
		return $params;
	}
	
	add_filter( 'urbango_edge_filter_search_holder_params', 'urbango_listing_override_listing_search_page_content_holder' );
}

if ( ! function_exists( 'urbango_listing_override_listing_search_page_sidebar_layout' ) ) {
	function urbango_listing_override_listing_search_page_sidebar_layout( $sidebar_layout ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$sidebar_layout = 'no-sidebar';
		}
		
		return $sidebar_layout;
	}
	
	add_filter( 'urbango_edge_filter_sidebar_layout', 'urbango_listing_override_listing_search_page_sidebar_layout' );
}

if ( ! function_exists( 'urbango_listing_disable_listing_search_page_title_area' ) ) {
	function urbango_listing_disable_listing_search_page_title_area( $show_title_area ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			return false;
		}
		
		return $show_title_area;
	}
	
	add_filter( 'urbango_edge_filter_show_title_area', 'urbango_listing_disable_listing_search_page_title_area' );
}

if ( ! function_exists( 'urbango_listing_set_filter_params_for_listing_search_page' ) ) {
	function urbango_listing_set_filter_params_for_listing_search_page( $params ) {
		
		if ( isset( $_GET['edgtf-listing-search'] ) ) {
			$params = array();
			
			$filter_args = array(
				'order_by',
				'custom_search',
				'category',
				'location',
				'tag',
				'amenity'
			);
			
			foreach ( $filter_args as $filter ) {
				$get_value = 'edgtf-search-' . str_replace( '_', '-', $filter );
				
				if ( isset( $_GET[ $get_value ] ) ) {
					
					if ( $filter === 'location' ) {
						$location_value      = esc_attr( strip_tags( $_GET[ $get_value ] ) );
						$location_term_value = is_numeric( $location_value ) ? get_term( intval( $location_value ), 'listing-' . $filter ) : '';
						$location_value      = ! empty( $location_term_value ) ? $location_term_value->name : $location_value;
						
						$params[ $filter ] =  $location_value;
					} else {
						$params[ $filter ] = esc_attr( strip_tags( $_GET[ $get_value ] ) );
					}
				}
			}
			
			if ( isset( $_GET['s'] ) && ! empty( $_GET['s'] ) ) {
				$params['custom_search'] = $_GET['s'];
			}
		}
		
		return $params;
	}
	
	add_filter( 'urbango_edge_filter_search_page_params', 'urbango_listing_set_filter_params_for_listing_search_page' );
}

if ( ! function_exists( 'urbango_listing_get_listing_search_page_content' ) ) {
	function urbango_listing_get_listing_search_page_content( $params ) {
		urbango_listing_get_archive_listing_item_content( '', '', '', $params );
	}
}
