<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$search_params = array(
	'custom_search' => array(
		'label' => esc_html__( 'Custom Search', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'location'      => array(
		'label' => esc_html__( 'Location', 'urbango-listing' ),
		'type'  => 'taxonomy'
	),
	'category'      => array(
		'label' => esc_html__( 'Category', 'urbango-listing' ),
		'type'  => 'taxonomy'
	),
	'tag'           => array(
		'label' => esc_html__( 'Tag', 'urbango-listing' ),
		'type'  => 'taxonomy'
	),
	'order_by'      => array(
		'label' => esc_html__( 'Order', 'urbango-listing' ),
		'type'  => 'simple'
	),
	'action'        => array(
		'label' => esc_html__( 'Action', 'urbango-listing' ),
		'type'  => false
	)
);
?>
<div class="edgtf-listing-profile-searches">
	<?php if ( ! empty( $user_searches ) ) { ?>
		<div class="edgtf-lp-section-title">
			<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'My Searches', 'urbango-listing' ); ?></h3>
			<p class="edgtf-lp-st-text"><?php esc_html_e( 'Access your saved searches and manage the search criteria you have defined.', 'urbango-listing' ); ?></p>
		</div>
		<div class="edgtf-lp-saved-searches">
			<div class="edgtf-lp-ss-heading">
				<?php foreach ( $search_params as $param_key => $param_value ) {
					$item_class = 'edgtf-lp-ss-heading-' . str_replace( '_', '-', $param_key );
					?>
					<span class="<?php echo esc_attr( $item_class ); ?>"><?php echo esc_attr( $param_value['label'] ); ?></span>
				<?php } ?>
			</div>
			<div class="edgtf-lp-ss-content">
				<?php foreach ( $user_searches as $key => $search ) { ?>
					<div class="edgtf-lp-ss-content-row">
						<?php foreach ( $search_params as $param_key => $param_value ) {
							$item_class = 'edgtf-lp-ss-content-' . str_replace( '_', '-', $param_key );
							$item_value = esc_html__( '/', 'urbango-listing' );
							
							if ( ! empty( $search[ $param_key ] ) ) {
								if ( $param_value['type'] === 'taxonomy' ) {
									$item_value = urbango_listing_get_cpt_taxonomy_items_name_by_ids( $search[ $param_key ] );
									
									if ( empty( $item_value ) && ! empty( $search[ $param_key ] ) ) {
										$item_value = $search[ $param_key ];
									}
								} else {
									$item_value = $search[ $param_key ];
								}
							}
							
							if ( ! empty( $param_value['type'] ) ) { ?>
								<div class="<?php echo esc_attr( $item_class ); ?>"><?php echo esc_html( $item_value ); ?></div>
							<?php } ?>
						<?php } ?>
						<div class="edgtf-lp-ss-content-action">
							<form role="search" method="get" class="edgtf-listing-search" action="<?php echo esc_url( home_url( "/" ) ); ?>">
								<input type="hidden" name="s" value=""/>
								<input type="hidden" name="edgtf-listing-search" value="yes"/>
								<?php foreach ( $search_params as $param_key => $param_value ) {
									$item_name = 'edgtf-search-' . str_replace( '_', '-', $param_key );
									
									if ( ! empty( $param_value['type'] ) ) { ?>
										<input type="hidden" name="<?php echo esc_attr( $item_name ); ?>" value="<?php echo esc_attr( $search[$param_key] ); ?>"/>
									<?php }
								} ?>
								<button class="edgtf-query-search-page">
									<span class="fas fa-link"></span>
									<span class="edgtf-qs-notice"><?php esc_html_e( 'Show search', 'urbango-listing' ); ?></span>
								</button>
							</form>
							<a href="#" class="edgtf-undo-query-save" data-query-id="<?php echo esc_attr( $key ); ?>">
		                        <span class="fas fa-times"></span>
								<span class="edgtf-qs-notice"><?php esc_html_e( 'Remove', 'urbango-listing' ); ?></span>
		                    </a>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
	<?php } else { ?>
		<h3 class="edgtf-lp-not-found"><?php esc_html_e( 'You don\'t have saved searches yet.', 'urbango-listing' ); ?> </h3>
	<?php } ?>
</div>