<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-listing-profile-my-listings">
	<?php if ( $listing_items ) { ?>
		<div class="edgtf-lp-section-title">
			<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'My Listings', 'urbango-listing' ); ?></h3>
			<p class="edgtf-lp-st-text"><?php esc_html_e( 'You will be able to locate all of your listings displayed below.', 'urbango-listing' ); ?></p>
		</div>
		<div class="edgtf-lp-listing-items">
			<?php foreach ( $listing_items as $id => $title ) { ?>
				<div class="edgtf-lp-listing-item">
					<div class="edgtf-lp-li-content">
						<?php if ( has_post_thumbnail( $id ) ) {
							echo get_the_post_thumbnail( $id, 'thumbnail' );
						} ?>
						<h4 class="edgtf-lp-li-title">
							<a href="<?php the_permalink( $id ); ?>"><?php echo esc_html( $title ); ?></a>
						</h4>
					</div>
					<div class="edgtf-lp-li-buttons">
						<?php if ( urbango_listing_is_core_plugin_installed() ) {
							echo urbango_edge_get_button_html( array(
								'custom_class' => 'edgtf-listing-item-preview',
								'type'         => 'outline',
								'size'         => 'small',
								'link'         => esc_url( get_permalink( $id ) ),
								'target'       => '_blank',
								'text'         => esc_html__( 'Preview', 'urbango-listing' ),
								'icon_pack'    => 'font_awesome',
								'fa_icon'      => 'far fa-object-group'
							) );
							
							echo urbango_edge_get_button_html( array(
								'custom_class' => 'edgtf-listing-item-edit',
								'type'         => 'outline',
								'size'         => 'small',
								'link'         => esc_url( add_query_arg( array( 'user-action' => 'edit-listing', 'listing_id'  => $id ), $dashboard_url ) ),
								'text'         => esc_html__( 'Edit', 'urbango-listing' ),
								'icon_pack'    => 'font_awesome',
								'fa_icon'      => 'far fa-edit'
							) );
							
							echo urbango_edge_get_button_html( array(
								'custom_class' => 'edgtf-listing-item-delete',
								'type'         => 'outline',
								'size'         => 'small',
								'link'         => '#',
								'text'         => esc_html__( 'Delete', 'urbango-listing' ),
								'icon_pack'    => 'font_awesome',
								'fa_icon'      => 'far fa-trash-alt',
								'custom_attrs' => array(
									'data-listing-id'   => $id,
									'data-confirm-text' => esc_html__( 'Are you sure you want to delete this listing?', 'urbango-listing' )
								)
							) );
						} ?>
					</div>
				</div>
			<?php } ?>
		</div>
	<?php } else { ?>
		<h3 class="edgtf-lp-not-found"><?php esc_html_e( 'You haven\'t added any listing yet.', 'urbango-listing' ); ?></h3>
	<?php } ?>
</div>