<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$listing_get_id = $_GET['listing_id'];
$listing_db_id  = esc_attr( intval( $listing_get_id ) );

if ( ! function_exists( 'urbango_listing_dashboard_edit_listing_fields' ) ) {
	function urbango_listing_dashboard_edit_listing_fields( $params, $listing_db_id ) {
		extract( $params );
		
		$edit_listing = urbango_edge_add_dashboard_fields(
			array(
				'name' => 'edit_listing'
			)
		);
		
		$edit_listing_form = urbango_edge_add_dashboard_form(
			array(
				'name'         => 'edit_listing_form',
				'form_id'      => 'edgtf-listing-edit-listing-form',
				'form_action'  => 'urbango_listing_edit_listing',
				'button_label' => esc_html__( 'Edit Listing', 'urbango-listing' ),
				'button_args'  => array(
					'data-updating-text' => esc_html__( 'Editing Listing', 'urbango-listing' ),
					'data-updated-text'  => esc_html__( 'Listing Edited', 'urbango-listing' ),
				),
				'parent'       => $edit_listing
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_db_id',
				'type'   => 'text',
				'value'  => $listing_db_id,
				'parent' => $edit_listing_form,
				'args'   => array(
					'input_type' => 'hidden'
				)
			)
		);
		
		// General front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_general_section',
				'title'  => esc_html__( 'General Section', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		if ( urbango_listing_check_if_user_has_featured_items() || urbango_listing_check_is_user_admin() ) {
			urbango_edge_add_dashboard_field(
				array(
					'name'    => 'listing_is_featured',
					'type'    => 'select',
					'value'   => isset( $edgtf_listing_is_featured_meta ) ? $edgtf_listing_is_featured_meta : '',
					'label'   => esc_html__( 'Listing Is Featured', 'urbango-listing' ),
					'options' => urbango_edge_get_yes_no_select_array(),
					'parent'  => $edit_listing_form,
					'args'    => array(
						'select2'      => true,
						'custom_class' => 'edgtf-listing-is-featured'
					)
				)
			);
		}
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_id_default',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_id_meta ) ? $edgtf_listing_id_meta : '',
				'label'  => esc_html__( 'Listing Item ID', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_title_default',
				'type'   => 'text',
				'value'  => isset( $listing_title_default ) ? $listing_title_default : '',
				'label'  => esc_html__( 'Title', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_description_default',
				'type'   => 'textarea',
				'value'  => isset( $listing_description_default ) ? $listing_description_default : '',
				'label'  => esc_html__( 'Description', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_excerpt_default',
				'type'   => 'textarea',
				'value'  => isset( $listing_excerpt_default ) ? $listing_excerpt_default : '',
				'label'  => esc_html__( 'Excerpt', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_title_logo',
				'type'   => 'image',
				'value'  => isset( $edgtf_listing_single_title_logo_meta ) ? $edgtf_listing_single_title_logo_meta : '',
				'label'  => esc_html__( 'Title Logo Image', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_featured_image_default',
				'type'   => 'image',
				'value'  => isset( $listing_featured_image_default ) ? $listing_featured_image_default : '',
				'label'  => esc_html__( 'Featured Image', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_single_price_range',
				'type'    => 'select',
				'value'   => isset( $edgtf_listing_single_price_range_meta ) ? $edgtf_listing_single_price_range_meta : '',
				'label'   => esc_html__( 'Price Range', 'urbango-listing' ),
				'options' => urbango_listing_get_listing_price_range(),
				'parent'  => $edit_listing_form
			)
		);
		
		// General front-end section - end
		
		// Gallery front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_gallery_section',
				'title'  => esc_html__( 'Gallery Section', 'urbango-listing' ),
				'parent' => $edit_listing_form
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_gallery_images',
				'type'   => 'gallery',
				'value'  => isset( $edgtf_listing_single_gallery_images_meta ) ? $edgtf_listing_single_gallery_images_meta : '',
				'label'  => esc_html__( 'Gallery Images', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-gallery-images edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Gallery front-end section - end
		
		// Category front-end section - begin
		
		$category_meta    = urbango_listing_get_cpt_taxonomy_items( 'category', false );
		$categories       = ! empty( $category_meta ) ? $category_meta : array();
		$categories_value = isset ( $listing_category_taxonomy ) ? $listing_category_taxonomy : '';
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_category_section',
				'title'  => esc_html__( 'Category Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-category-section',
					'icon_class'   => 'far fa-folder'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_category_taxonomy',
				'type'    => 'checkboxgroup',
				'value'   => $categories_value,
				'label'   => esc_html__( 'Category', 'urbango-listing' ),
				'options' => $categories,
				'parent'  => $edit_listing_form,
				'args'    => array(
					'custom_class' => 'edgtf-listing-category edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Category front-end section - end
		
		// Tag front-end section - begin
		
		$tag_meta   = urbango_listing_get_cpt_taxonomy_items( 'tag', false );
		$tags       = ! empty( $tag_meta ) ? $tag_meta : array();
		$tags_value = isset ( $listing_tag_taxonomy ) ? $listing_tag_taxonomy : '';
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_tag_section',
				'title'  => esc_html__( 'Tag Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-tag-section',
					'icon_class'   => 'far fa-bookmark'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_tag_taxonomy',
				'type'    => 'checkboxgroup',
				'value'   => $tags_value,
				'label'   => esc_html__( 'Tag', 'urbango-listing' ),
				'options' => $tags,
				'parent'  => $edit_listing_form,
				'args'    => array(
					'custom_class' => 'edgtf-listing-tag edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Tag front-end section - end
		
		// Location front-end section - begin
		
		$location_meta = urbango_listing_get_cpt_taxonomy_items( 'location' );
		$locations     = ! empty( $location_meta ) ? $location_meta : array();
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_location_section',
				'title'  => esc_html__( 'Location Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-location-section',
					'icon_class'   => 'far fa-map'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'    => 'listing_location_taxonomy',
				'type'    => 'select',
				'value'   => isset( $listing_location_taxonomy ) ? $listing_location_taxonomy : '',
				'label'   => esc_html__( 'City', 'urbango-listing' ),
				'options' => $locations,
				'parent'  => $edit_listing_form,
				'args'    => array(
					'select2' => true,
					'custom_class' => 'edgtf-listing-location'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_full_address',
				'type'   => 'address',
				'value'  => isset( $edgtf_listing_single_full_address_meta ) ? $edgtf_listing_single_full_address_meta : '',
				'label'  => esc_html__( 'Full Address', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'latitude_field'  => 'listing_single_full_address_latitude',
					'longitude_field' => 'listing_single_full_address_longitude',
					'custom_class'    => 'edgtf-listing-full-address edgtf-dashboard-field-full-width'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_full_address_latitude',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_full_address_latitude_meta ) ? $edgtf_listing_single_full_address_latitude_meta : '',
				'label'  => esc_html__( 'Latitude', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-dashboard-address-elements edgtf-listing-latitude-address'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_full_address_longitude',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_full_address_longitude_meta ) ? $edgtf_listing_single_full_address_longitude_meta : '',
				'label'  => esc_html__( 'Longitude', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-dashboard-address-elements edgtf-listing-longitude-address'
				)
			)
		);
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_location_contact_section',
				'title'  => esc_html__( 'Contact Information', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-location-contact-section',
					'icon_class'   => 'far fa-envelope'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_phone',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_phone_meta ) ? $edgtf_listing_single_contact_phone_meta : '',
				'label'  => esc_html__( 'Phone', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-phone'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_email',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_email_meta ) ? $edgtf_listing_single_contact_email_meta : '',
				'label'  => esc_html__( 'Email', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-email'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_site_url',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_site_url_meta ) ? $edgtf_listing_single_contact_site_url_meta : '',
				'label'  => esc_html__( 'Site URL', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-site-url'
				)
			)
		);
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_location_social_section',
				'title'  => esc_html__( 'Social Information', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-contact-social-section',
					'icon_class'   => 'far fa-share-square'
				)
				
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_facebook',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_facebook_meta ) ? $edgtf_listing_single_contact_facebook_meta : '',
				'label'  => esc_html__( 'Facebook Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-facebook'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_twitter',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_twitter_meta ) ? $edgtf_listing_single_contact_twitter_meta : '',
				'label'  => esc_html__( 'Twiiter Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-twitter'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_instagram',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_instagram_meta ) ? $edgtf_listing_single_contact_instagram_meta : '',
				'label'  => esc_html__( 'Instagram Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-instagram'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_tripadvisor',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_tripadvisor_meta ) ? $edgtf_listing_single_contact_tripadvisor_meta : '',
				'label'  => esc_html__( 'Tripadvisor Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-tripadvisor'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_youtube',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_youtube_meta ) ? $edgtf_listing_single_contact_youtube_meta : '',
				'label'  => esc_html__( 'YouTube Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-youtube'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_google_plus',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_google_plus_meta ) ? $edgtf_listing_single_contact_google_plus_meta : '',
				'label'  => esc_html__( 'Google+ Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-google-plus'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_pinterest',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_pinterest_meta ) ? $edgtf_listing_single_contact_pinterest_meta : '',
				'label'  => esc_html__( 'Pinterest Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-pinterest'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'   => 'listing_single_contact_yelp',
				'type'   => 'text',
				'value'  => isset( $edgtf_listing_single_contact_yelp_meta ) ? $edgtf_listing_single_contact_yelp_meta : '',
				'label'  => esc_html__( 'Yelp Link', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-listing-contact-yelp'
				)
			)
		);
		
		// Location front-end section - end
		
		// Amenity front-end section - begin
		
		$amenity_meta = urbango_listing_get_cpt_taxonomy_items( 'amenity', false );
		$amenities    = ! empty( $amenity_meta ) ? $amenity_meta : array();
		
		$included_amenities = isset ( $edgtf_listing_single_included_amenities_meta ) ? $edgtf_listing_single_included_amenities_meta : '';
		$excluded_amenities = isset ( $edgtf_listing_single_excluded_amenities_meta ) ? $edgtf_listing_single_excluded_amenities_meta : '';
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_amenity_section',
				'title'  => esc_html__( 'Amenity Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-amenity-section',
					'icon_class'   => 'far fa-check-square'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_included_amenities',
				'type'        => 'checkboxgroup',
				'value'       => unserialize( $included_amenities ),
				'label'       => esc_html__( 'Included Amenities', 'urbango-listing' ),
				'description' => esc_html__( 'Define included amenities for listing single page', 'urbango-listing' ),
				'options'     => $amenities,
				'parent'      => $edit_listing_form,
				'args'        => array(
					'custom_class' => 'edgtf-listing-included-amenity edgtf-dashboard-field-full-width'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_excluded_amenities',
				'type'        => 'checkboxgroup',
				'value'       => unserialize( $excluded_amenities ),
				'label'       => esc_html__( 'Excluded Amenities', 'urbango-listing' ),
				'description' => esc_html__( 'Define excluded amenities for listing single page', 'urbango-listing' ),
				'options'     => $amenities,
				'parent'      => $edit_listing_form,
				'args'        => array(
					'custom_class' => 'edgtf-listing-excluded-amenity edgtf-dashboard-field-full-width'
				)
			)
		);
		
		// Amenity front-end section - end
		
		// Open Table front-end section - begin
		
		if ( urbango_listing_check_is_listing_open_table_allowed() ) {
			
			urbango_edge_add_dashboard_section_title(
				array(
					'name'   => 'add_listing_open_table_section',
					'title'  => esc_html__( 'Open Table Section', 'urbango-listing' ),
					'parent' => $edit_listing_form,
					'args'   => array(
						'custom_class' => 'edgtf-open-table-section',
						'icon_class'   => 'far fa-calendar-check'
					)
				)
			);
			
			urbango_edge_add_dashboard_field(
				array(
					'name'        => 'listing_single_open_table_id',
					'type'        => 'text',
					'value'       => isset( $edgtf_listing_single_open_table_id_meta ) ? $edgtf_listing_single_open_table_id_meta : '',
					'label'       => esc_html__( 'Open Table ID', 'urbango-listing' ),
					'description' => esc_html__( 'Add your OpenTable ID for the listing single page', 'urbango-listing' ),
					'parent'      => $edit_listing_form,
					'args'        => array(
						'custom_class' => 'edgtf-listing-open-table-id'
					)
				)
			);
		}
		
		// Open Table front-end section - end
		
		// Reviews Criteria front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_reviews_criteria_section',
				'title'  => esc_html__( 'Reviews Criteria Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-reviews-criteria-section',
					'icon_class'   => 'far fa-star'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_reviews',
				'type'        => 'select',
				'value'       => isset( $edgtf_listing_single_reviews_meta ) ? $edgtf_listing_single_reviews_meta : '',
				'label'       => esc_html__( 'Show Reviews', 'urbango-listing' ),
				'description' => esc_html__( 'Enabling this option will show reviews on your listing single page', 'urbango-listing' ),
				'options'     => urbango_edge_get_yes_no_select_array(),
				'parent'      => $edit_listing_form,
				'args'        => array(
					'select2'      => true,
					'custom_class' => 'edgtf-listing-reviews'
				)
			)
		);
		
		$reviews_criteria = urbango_listing_get_cpt_taxonomy_items( 'reviews-criteria' );
		
		if ( ! empty( $reviews_criteria ) ) {
			
			urbango_edge_add_dashboard_field(
				array(
					'name'        => 'listing_single_advanced_reviews',
					'type'        => 'select',
					'value'       => isset( $edgtf_listing_single_advanced_reviews_meta ) ? $edgtf_listing_single_advanced_reviews_meta : '',
					'label'       => esc_html__( 'Enable Advanced Reviews', 'urbango-listing' ),
					'description' => esc_html__( 'Enabling this option will show advanced reviews criteria in reviews on your listing single page', 'urbango-listing' ),
					'options'     => urbango_edge_get_yes_no_select_array(),
					'parent'      => $edit_listing_form,
					'args'        => array(
						'select2'      => true,
						'custom_class' => 'edgtf-listing-advanced-reviews'
					)
				)
			);
		}
		
		// Reviews Criteria front-end section - end
		
		// Business Hours front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_business_hours_section',
				'title'  => esc_html__( 'Business Hours Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-business-hours-section',
					'icon_class'   => 'far fa-clock'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'name'        => 'listing_single_business_hours_time_zone',
				'type'        => 'select',
				'value'       => isset( $edgtf_listing_single_business_hours_time_zone_meta ) ? $edgtf_listing_single_business_hours_time_zone_meta : '',
				'label'       => esc_html__( 'Date Time Zone', 'urbango-listing' ),
				'description' => esc_html__( 'Choose your time zone for setting your business hours time', 'urbango-listing' ),
				'options'     => urbango_listing_get_date_time_zone(),
				'parent'      => $edit_listing_form,
				'args'        => array(
					'select2' => true,
					'custom_class' => 'edgtf-listing-business-hours-time-zone'
				)
			)
		);
		
		urbango_edge_add_dashboard_repeater_field(
			array(
				'name'         => 'listing_single_business_hours',
				'button_text'  => '',
				'value'        => isset( $edgtf_listing_single_business_hours_meta ) ? unserialize( $edgtf_listing_single_business_hours_meta ) : '',
				'parent'       => $edit_listing_form,
				'table_layout' => true,
				'fields'       => array(
					array(
						'name'      => 'day',
						'type'      => 'select',
						'label'     => esc_html__( 'Day', 'urbango-listing' ),
						'th'        => esc_html__( 'Day', 'urbango-listing' ),
						'options'   => urbango_listing_get_weekend_days(),
						'col_width' => '4',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => 'open_time',
						'type'      => 'select',
						'label'     => esc_html__( 'Open Time', 'urbango-listing' ),
						'th'        => esc_html__( 'Open Time', 'urbango-listing' ),
						'options'   => urbango_listing_get_hours_range(),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => 'end_time',
						'type'      => 'select',
						'label'     => esc_html__( 'End Time', 'urbango-listing' ),
						'th'        => esc_html__( 'End Time', 'urbango-listing' ),
						'options'   => urbango_listing_get_hours_range(),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => '24h_open',
						'type'      => 'select',
						'label'     => esc_html__( '24 Hours', 'urbango-listing' ),
						'th'        => esc_html__( '24 Hours', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					),
					array(
						'name'      => 'closed',
						'type'      => 'select',
						'label'     => esc_html__( 'Closed', 'urbango-listing' ),
						'th'        => esc_html__( 'Closed', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '2',
						'args'      => array(
							'select2' => true
						)
					)
				)
			)
		);
		
		// Business Hours front-end section - end
		
		// Additional Info front-end section - begin
		
		urbango_edge_add_dashboard_section_title(
			array(
				'name'   => 'add_listing_additional_info_section',
				'title'  => esc_html__( 'Additional Info Section', 'urbango-listing' ),
				'parent' => $edit_listing_form,
				'args'   => array(
					'custom_class' => 'edgtf-additional-info-section',
					'icon_class'   => 'far fa-plus-square'
				)
			)
		);
		
		urbango_edge_add_dashboard_repeater_field(
			array(
				'name'         => 'listing_single_additional_info',
				'button_text'  => '',
				'value'        => isset( $edgtf_listing_single_additional_info_meta ) ? unserialize( $edgtf_listing_single_additional_info_meta ) : '',
				'parent'       => $edit_listing_form,
				'table_layout' => true,
				'fields'       => array(
					array(
						'name'      => 'label',
						'type'      => 'text',
						'label'     => esc_html__( 'Label', 'urbango-listing' ),
						'th'        => esc_html__( 'Label', 'urbango-listing' ),
						'col_width' => '4'
					),
					array(
						'name'      => 'value',
						'type'      => 'text',
						'label'     => esc_html__( 'Value', 'urbango-listing' ),
						'th'        => esc_html__( 'Value', 'urbango-listing' ),
						'col_width' => '4'
					),
					array(
						'name'      => 'value_link',
						'type'      => 'text',
						'label'     => esc_html__( 'Value Link', 'urbango-listing' ),
						'th'        => esc_html__( 'Value Link', 'urbango-listing' ),
						'col_width' => '4'
					)
				)
			)
		);
		
		// Additional Info front-end section - end
		
		$edit_listing->render();
	}
}
?>
<div class="edgtf-listing-profile-edit-listing">
	<div class="edgtf-lp-section-title">
		<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Edit Listing Item', 'urbango-listing' ); ?></h3>
		<p class="edgtf-lp-st-text"><?php esc_html_e( 'Here you can edit every part of the listing. Please note that fields marked with an asterisk (*) have to be filled before you can apply changes.', 'urbango-listing' ); ?></p>
	</div>
	<div>
		<?php urbango_listing_dashboard_edit_listing_fields( urbango_listing_get_listing_meta( $listing_db_id ), $listing_db_id ); ?>
		<?php do_action( 'urbango_membership_action_login_ajax_response' ); ?>
	</div>
</div>