<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_profile_navigation_item' ) ) {
	function urbango_listing_add_profile_navigation_item( $navigation, $dashboard_url ) {
		$user = wp_get_current_user();
		
		//Check if role in approved roles
		if ( urbango_listing_approved_user_roles( $user->roles ) ) {
			if ( post_type_exists( 'listing-item' ) ) {
				$package = urbango_listing_check_is_package_available();
				
				//strongly false because of the 0 key for packages
				if ( $package !== false ) {
					$add_listing_url = esc_url( add_query_arg( array( 'user-action' => 'add-listing' ), $dashboard_url ) );
				} else {
					$add_listing_url = urbango_listing_get_pricing_packages_page();
				}
				
				$navigation['add-listing'] = array(
					'url'         => $add_listing_url,
					'text'        => esc_html__( 'Add Listing', 'urbango-listing' ),
					'user_action' => 'add-listing',
					'icon'        => 'add-listing',
					'font_icon'   => array( 'far fa-plus-square', 'font_awesome' )
				);
				
				$navigation['my-listings'] = array(
					'url'         => esc_url( add_query_arg( array( 'user-action' => 'my-listings' ), $dashboard_url ) ),
					'text'        => esc_html__( 'My Listings', 'urbango-listing' ),
					'user_action' => 'my-listings',
					'icon'        => 'my-listings',
					'font_icon'   => array( 'far fa-clipboard', 'font_awesome' )
				);
			}
		}
		
		$navigation['my-wishlist'] = array(
			'url'         => esc_url( add_query_arg( array( 'user-action' => 'my-wishlist' ), $dashboard_url ) ),
			'text'        => esc_html__( 'My Wishlist', 'urbango-listing' ),
			'user_action' => 'my-wishlist',
			'icon'        => 'my-wishlist',
			'font_icon'   => array( 'far fa-heart', 'font_awesome' )
		);
		
		$navigation['listing-searches'] = array(
			'url'         => esc_url( add_query_arg( array( 'user-action' => 'listing-searches' ), $dashboard_url ) ),
			'text'        => esc_html__( 'My Searches', 'urbango-listing' ),
			'user_action' => 'listing-searches',
			'icon'        => 'saved-searches',
			'font_icon'   => array( 'icon_search', 'font_elegant' )
		);
		
		return $navigation;
	}
	
	add_filter( 'urbango_membership_dashboard_navigation_pages', 'urbango_listing_add_profile_navigation_item', 15, 2 );
}

if ( ! function_exists( 'urbango_listing_add_profile_navigation_pages' ) ) {
	function urbango_listing_add_profile_navigation_pages( $page, $action ) {
		$user = wp_get_current_user();
		
		if ( $action == 'my-wishlist' ) {
			$page = urbango_listing_get_module_template_part( 'modules', 'wishlist', 'profile/templates/my-wishlist', '', array(), array(), false );
		} else if ( $action == 'listing-searches' ) {
			$searches_params                  = array();
			$user_searches                    = get_user_meta( get_current_user_id(), 'edgtf_user_saved_queries', true );
			$searches_params['user_searches'] = $user_searches;
			$page                             = urbango_listing_get_module_template_part( 'cpt-listing-profile', 'listing', 'searches-list', '', $searches_params, array(), false );
		} else if ( $action == 'edit-listing' && urbango_listing_approved_user_roles( $user->roles ) ) {
			$page = urbango_listing_get_module_template_part( 'cpt-listing-profile', 'listing', 'edit-listing', '', array(), array(), false );
		} else if ( $action == 'add-listing' && urbango_listing_approved_user_roles( $user->roles ) ) {
			$add_listing_params = urbango_listing_get_add_listing_params();
			$page               = urbango_listing_get_module_template_part( 'cpt-listing-profile', 'listing', 'add-listing', '', $add_listing_params, array(), false );
		} else if ( $action == 'my-listings' && urbango_listing_approved_user_roles( $user->roles ) && urbango_listing_is_membership_plugin_installed() ) {
			$list_params['listing_items'] = urbango_listing_get_cpt_items( 'listing-item', array( 'post_status' => array( 'publish', 'pending', 'draft' ), 'author' => get_current_user_id() ) );
			$list_params['dashboard_url'] = urbango_membership_get_dashboard_page_url();
			$page                         = urbango_listing_get_module_template_part( 'cpt-listing-profile', 'listing', 'my-listings', '', $list_params, array(), false );
		}
		
		return $page;
	}
	
	add_filter( 'urbango_membership_dashboard_pages', 'urbango_listing_add_profile_navigation_pages', 10, 2 );
}

if ( ! function_exists( 'urbango_listing_get_listing_items_ids' ) ) {
	function urbango_listing_get_listing_items_ids() {
		$listing_ids   = array();
		$listing_items = urbango_listing_get_cpt_items( 'listing-item' );
		
		if ( ! empty( $listing_items ) ) {
			foreach ( $listing_items as $id => $title ) {
				$listing_meta = get_post_meta( $id, 'edgtf_listing_id_meta', true );
				
				if ( ! empty( $listing_meta ) ) {
					$listing_ids[] = $listing_meta;
				}
			}
		}
		
		return $listing_ids;
	}
}

if ( ! function_exists( 'urbango_listing_add_listing' ) ) {
	function urbango_listing_add_listing() {
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'All fields are empty.', 'urbango-listing' ) );
		} else {
			$dashboard_url = urbango_listing_is_membership_plugin_installed() ? urbango_membership_get_dashboard_page_url() : '#';
			parse_str( $_POST['data'], $new_listing_data );
			
			$user        = wp_get_current_user();
			$nonce_name  = 'edgtf_validate_' . $new_listing_data['edgtf_form_name'] . '_' . $user->ID;
			$nonce_value = 'edgtf_nonce_' . $new_listing_data['edgtf_form_name'] . '_' . $user->ID;
			
			//Check nonce
			if ( wp_verify_nonce( $new_listing_data[ $nonce_value ], $nonce_name ) && urbango_listing_approved_user_roles( $user->roles ) ) {
				$listing_params               = array();
				$listing_params['meta_input'] = array();
				$listing_params['tax_input']  = array();
				
				//Check if listing id already exists
				$listing_ids = urbango_listing_get_listing_items_ids();
				
				if ( in_array( $new_listing_data['listing_id_default'], $listing_ids ) ) {
					urbango_listing_get_ajax_status( 'error', esc_html__( 'Item ID is taken, please try another.', 'urbango-listing' ) );
				} else {
					$listing_params['meta_input']['edgtf_listing_id_meta'] = $new_listing_data['listing_id_default'];
				}
				
				if ( empty( $new_listing_data['listing_title_default'] ) ) {
					urbango_listing_get_ajax_status( 'error', esc_html__( 'Please enter item title.', 'urbango-listing' ) );
				}
				
				$listing_params['post_type']    = 'listing-item';
				$listing_params['post_title']   = $new_listing_data['listing_title_default'];
				$listing_params['post_content'] = $new_listing_data['listing_description_default'];
				$listing_params['post_excerpt'] = $new_listing_data['listing_excerpt_default'];
				
				foreach ( $new_listing_data as $key => $value ) {
					// Hidden values are images options and default values are core WP meta fields
					if ( strpos( $key, 'hidden_' ) === false && strpos( $key, '_default' ) === false ) {
						
						if ( strpos( $key, '_taxonomy' ) !== false && ! empty( $value ) ) {
							$listing_params['tax_input'][ str_replace( array( '_taxonomy', '_' ), array( '', '-' ), $key ) ] = is_array( $value ) && count( $value ) ? implode( ',', $value ) : $value;
						} else if ( strpos( $key, '_new_item' ) !== false && ! empty( $value ) ) {
							$taxonomy_id     = array();
							$taxonomy_name   = str_replace( array( '_new_item', '_' ), array( '', '-' ), $key );
							$taxonomy_values = explode( ',', esc_attr( esc_html( $value ) ) );
							
							foreach ( $taxonomy_values as $taxonomy_value ) {
								$taxonomy_exist = term_exists( $taxonomy_value, $taxonomy_name );
								
								// Check is new taxonomy exist
								if ( empty( $taxonomy_exist ) ) {
									// Add new taxonomy value
									$add_taxonomy_value = wp_insert_term( $taxonomy_value, $taxonomy_name );
									
									if ( ! is_wp_error( $add_taxonomy_value ) ) {
										$taxonomy_id[] = $add_taxonomy_value['term_id'];
									} else {
										urbango_listing_get_ajax_status( 'error', sprintf( esc_html__( '%s item can\'t be created.', 'urbango-listing' ), $taxonomy_value ) );
									}
								} else {
									urbango_listing_get_ajax_status( 'error', sprintf( esc_html__( 'Please add unique name for %s, that name already exist.', 'urbango-listing' ), ucwords( str_replace( 'listing-', '', $taxonomy_name ) ) ) );
								}
							}
							
							if ( ! empty( $taxonomy_id ) ) {
								$listing_params['tax_input'][ $taxonomy_name ] = implode( ',', $taxonomy_id );
							}
						} else {
							
							if ( strpos( $key, 'included_amenities' ) !== false ) {
								$listing_params['meta_input'][ 'edgtf_' . $key . '_meta' ] = $value;
								$listing_params['tax_input']['listing-amenity'] = implode( ',', $value );
							} else {
								$listing_params['meta_input'][ 'edgtf_' . $key . '_meta' ] = $value;
							}
						}
					}
				}
				
				// WordPress handles the upload (keys form $_FILES used).
				$featured_image_id           = '';
				$listing_image_gallery_array = array();
				
				foreach ( $_FILES as $key => $value ) {
					$name = '';
					
					if ( stripos( $key, '_edgtf_reg_' ) ) {
						$lastLetterPos = stripos( $key, '_edgtf_reg_' );
						$name          = substr( $key, 0, $lastLetterPos );
						
					} elseif ( stripos( $key, '_edgtf_regarray_' ) ) {
						$lastLetterPos = stripos( $key, '_edgtf_regarray_' );
						$name          = substr( $key, 0, $lastLetterPos );
					}
					
					if ( $value['name'] === 'edgtf-dummy-file.txt' ) {
						$attachment_id  = '';
						$attachment_url = '';
					} else {
						$attachment_id  = media_handle_upload( $key, 0 );
						$attachment_url = wp_get_attachment_url( $attachment_id );
					}
					
					if ( is_wp_error( $attachment_id ) ) {
						urbango_listing_get_ajax_status( 'error', esc_html__( 'Image not uploaded, please try again.', 'urbango-listing' ) );
					} else {
						switch ( $name ) {
							case 'listing_featured_image_default':
								$featured_image_id = $attachment_id;
								break;
							case 'listing_single_title_logo':
								$listing_params['meta_input']['edgtf_listing_single_title_logo_meta'] = $attachment_url;
								break;
							case 'listing_single_gallery_images':
								$listing_image_gallery_array[] = $attachment_id;
								break;
						}
					}
				}
				
				//add multiple images to single edgtf_listing_single_gallery_images_meta field
				$listing_params['meta_input']['edgtf_listing_single_gallery_images_meta'] = implode( ',', $listing_image_gallery_array );
				
				$user_role = 'owner';
				
				$listing_params['meta_input']['edgtf_listing_contact_info_meta']               = $user_role;
				$listing_params['meta_input']['edgtf_listing_contact_' . $user_role . '_meta'] = $user->ID;
				
				$listing_params['meta_input']['edgtf_listing_package_meta'] = $new_listing_data['listing_package'];
				
				$user_can_published = urbango_edge_options()->getOptionValue( 'listing_enable_publish_from_user' );
				if ( $user_can_published === 'yes' ) {
					$listing_params['post_status'] = 'publish';
				}
				
				$listing_id = wp_insert_post( $listing_params );
				
				if ( ! is_wp_error( $listing_id ) ) {
					// Remove data from global post variable after submission
					unset( $_POST['data'] );
					
					set_post_thumbnail( $listing_id, $featured_image_id );
					
					urbango_listing_get_ajax_status( 'success', esc_html__( 'Listing is successfully added.', 'urbango-listing' ), null, $dashboard_url );
				} else {
					urbango_listing_get_ajax_status( 'error', esc_html__( 'Error during listing creating.', 'urbango-listing' ) );
				}
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Nonce is invalid.', 'urbango-listing' ) );
			}
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_add_listing', 'urbango_listing_add_listing' );
}

if ( ! function_exists( 'urbango_listing_get_listing_meta' ) ) {
	function urbango_listing_get_listing_meta( $listing_id ) {
		$meta_values = array();
		
		if ( ! empty( $listing_id ) ) {
			$id   = intval( $listing_id );
			$meta = get_post_meta( $id );
			
			// Dynamically loop throw all core WordPress fields, because these fields are stored in the different table
			$wp_fields = array(
				'title'          => get_the_title( $id ),
				'featured_image' => get_post_thumbnail_id( $id ),
				'description'    => get_post_field( 'post_content', $id ),
				'excerpt'        => get_post_field( 'post_excerpt', $id )
			);
			
			foreach ( $wp_fields as $key => $value ) {
				$meta_values[ 'listing_' . $key . '_default' ] = $value;
			}
			
			// Dynamically loop throw all meta options
			foreach ( $meta as $key => $value ) {
				$meta_values[ $key ] = $value[0];
			}
			
			// Dynamically loop throw all taxonomies, because these fields are stored in the different table
			$taxonomies = array(
				'category',
				'location',
				'amenity',
				'tag'
			);
			
			foreach ( $taxonomies as $taxonomy ) {
				$term_value = array();
				$terms      = get_the_terms( $id, 'listing-' . $taxonomy );
				
				if ( ! empty( $terms ) ) {
					foreach ( $terms as $term ) {
						$term_value[ $term->slug ] = $term->term_id;
					}
				}
				
				// This condition is necessary because location is select field type and we need to return only taxonomy id
				if ( $taxonomy === 'location' ) {
					$meta_values[ 'listing_' . $taxonomy . '_taxonomy' ] = intval( implode( '', $term_value ) );
				} else {
					$meta_values[ 'listing_' . $taxonomy . '_taxonomy' ] = $term_value;
				}
			}
		}
		
		return $meta_values;
	}
}

if ( ! function_exists( 'urbango_listing_edit_listing' ) ) {
	function urbango_listing_edit_listing() {
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'All fields are empty.', 'urbango-listing' ) );
		} else {
			parse_str( $_POST['data'], $new_listing_data );
			$listing_db_id = $new_listing_data['listing_db_id'];
			$dashboard_url = urbango_listing_is_membership_plugin_installed() ? urbango_membership_get_dashboard_page_url() : '#';
			
			$user        = wp_get_current_user();
			$nonce_name  = 'edgtf_validate_' . $new_listing_data['edgtf_form_name'] . '_' . $user->ID;
			$nonce_value = 'edgtf_nonce_' . $new_listing_data['edgtf_form_name'] . '_' . $user->ID;
			
			//Check nonce
			if ( wp_verify_nonce( $new_listing_data[ $nonce_value ], $nonce_name ) && urbango_listing_approved_user_roles( $user->roles ) ) {
				$listing_params               = array();
				$listing_params['meta_input'] = array();
				$listing_params['tax_input']  = array();
				
				//Check if listing id already exists
				$listing_ids        = urbango_listing_get_listing_items_ids();
				$current_listing_id = get_post_meta( $listing_db_id, 'edgtf_listing_id_meta', true );
				
				if ( $current_listing_id !== $new_listing_data['listing_id_default'] ) {
					//Check if listing id already exists 
					if ( in_array( $new_listing_data['listing_id_default'], $listing_ids ) ) {
						urbango_listing_get_ajax_status( 'error', esc_html__( 'Item ID is taken, please try another.', 'urbango-listing' ) );
					} else {
						$listing_params['meta_input']['edgtf_listing_id_meta'] = $new_listing_data['listing_id_default'];
					}
				}
				
				if ( empty( $new_listing_data['listing_title_default'] ) ) {
					urbango_listing_get_ajax_status( 'error', esc_html__( 'Please enter item title.', 'urbango-listing' ) );
				}
				
				foreach ( $new_listing_data as $key => $value ) {
					// Hidden values are images options and default values are core WP meta fields
					if ( strpos( $key, 'hidden_' ) === false && strpos( $key, '_default' ) === false ) {
						
						if ( strpos( $key, '_taxonomy' ) !== false && ! empty( $value ) ) {
							$listing_params['tax_input'][ str_replace( array( '_taxonomy', '_' ), array( '', '-' ), $key ) ] = is_array( $value ) && count( $value ) ? array_map( 'intval', $value ) : intval( $value );
						} else {
							
							if ( strpos( $key, 'included_amenities' ) !== false ) {
								$listing_params['meta_input'][ 'edgtf_' . $key . '_meta' ] = $value;
								$listing_params['tax_input']['listing-amenity'] = array_map( 'intval', $value );
							} else {
								$listing_params['meta_input'][ 'edgtf_' . $key . '_meta' ] = $value;
							}
						}
					}
				}
				
				$attachments = array(
					'listing_featured_image_default',
					'listing_single_title_logo',
					'listing_single_gallery_images'
				);
				
				$featured_image_id           = '';
				$listing_image_gallery_array = array();
				
				// Remove media, it needs to be before adding media, in case user removed and then uploaded some media
				foreach ( $attachments as $attachment_meta ) {
					$attachment_meta_db = $new_listing_data[ 'hidden_' . $attachment_meta ];

					if ( empty( $attachment_meta_db ) ) {
						if ( strpos( $attachment_meta, 'featured_image' ) !== false ) {
							$featured_image_id = 'removed';
						} else {
							$listing_params['meta_input'][ 'edgtf_' . $attachment_meta . '_meta' ] = '';
						}
					} else {
						$listing_params['meta_input'][ 'edgtf_' . $attachment_meta . '_meta' ] = $attachment_meta_db;
					}
				}
				
				// WordPress handles the upload (keys form $_FILES used).
				foreach ( $_FILES as $key => $value ) {
					$name = '';
					
					if ( stripos( $key, '_edgtf_reg_' ) ) {
						$lastLetterPos = stripos( $key, '_edgtf_reg_' );
						$name          = substr( $key, 0, $lastLetterPos );
						
					} elseif ( stripos( $key, '_edgtf_regarray_' ) ) {
						$lastLetterPos = stripos( $key, '_edgtf_regarray_' );
						$name          = substr( $key, 0, $lastLetterPos );
					}
					
					if ( $value['name'] === 'edgtf-dummy-file.txt' ) {
						$attachment_id  = '';
						$attachment_url = '';
					} else {
						$attachment_id  = media_handle_upload( $key, 0 );
						$attachment_url = wp_get_attachment_url( $attachment_id );
					}


					if ( is_wp_error( $attachment_id ) ) {
						urbango_listing_get_ajax_status( 'error', esc_html__( 'Media not uploaded, please try again.', 'urbango-listing' ) );
					} else {
						switch ( $name ) {
							case 'listing_featured_image_default':
								$featured_image_id = $attachment_id;
								break;
							case 'listing_single_title_logo':
								if( $listing_params['meta_input']['edgtf_listing_single_title_logo_meta'] !== $attachment_url && ! empty( $attachment_url )) {
									$listing_params['meta_input']['edgtf_listing_single_title_logo_meta'] = $attachment_url;
								}
								break;
							case 'listing_single_gallery_images':
								if( ! empty( $attachment_id ) && !( in_array( $attachment_id , $listing_image_gallery_array ))) {
									$listing_image_gallery_array[] = $attachment_id;
								}
								break;
						}
					}
				}



				// Update featured image
				if ( $featured_image_id !== '' ) {
					
					if ( $featured_image_id === 'removed' ) {
						delete_post_thumbnail( $listing_db_id );
					} else {
						set_post_thumbnail( $listing_db_id, $featured_image_id );
					}
				}
				
				// Add multiple images for meta field
				if ( ! empty( $listing_image_gallery_array ) ) {
					$listing_params['meta_input']['edgtf_listing_single_gallery_images_meta'] = implode( ',', $listing_image_gallery_array );
				}


				// Set core WordPress fields
				$this_listing_args = array(
					'ID'           => $listing_db_id,
					'post_title'   => $new_listing_data['listing_title_default'],
					'post_content' => $new_listing_data['listing_description_default'],
					'post_excerpt' => $new_listing_data['listing_excerpt_default']
				);
				
				// Update meta fieldsdel
				foreach ( $listing_params['meta_input'] as $key => $value ) {
					update_post_meta( $listing_db_id, $key, $value );
				}
				
				// Update terms fields
				foreach ( $listing_params['tax_input'] as $key => $value ) {
					wp_set_object_terms( $listing_db_id, $value, $key );
				}

				// Update the listing into the database
				$listing_id_success = wp_update_post( $this_listing_args );
				if ( ! is_wp_error( $listing_id_success ) ) {
					// Remove data from global post variable after submission
					unset( $_POST['data'] );
					
					urbango_listing_get_ajax_status( 'success', esc_html__( 'Listing is successfully edited.', 'urbango-listing' ), null, $dashboard_url );
				} else {
					urbango_listing_get_ajax_status( 'error', esc_html__( 'Error during listing saving.', 'urbango-listing' ) );
				}
				
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Nonce is invalid.', 'urbango-listing' ) );
			}
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_edit_listing', 'urbango_listing_edit_listing' );
}

if ( ! function_exists( 'urbango_listing_delete_listing' ) ) {
	function urbango_listing_delete_listing() {
		if ( ! isset( $_POST ) || empty( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'All fields are empty.', 'urbango-listing' ) );
		} else {
			$listing_id = intval( $_POST['listing_id'] );
			$user       = wp_get_current_user();
			
			// Check is listing item empty
			if ( empty( $listing_id ) ) {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Listing ID is invalid.', 'urbango-listing' ) );
			}
			
			//Check if role in approved roles
			if ( urbango_listing_approved_user_roles( $user->roles ) ) {
				$deleted = wp_delete_post( $listing_id );
				
				if ( $deleted ) {
					// Remove data from global post variable after submission
					unset( $_POST['listing_id'] );
					
					urbango_listing_get_ajax_status( 'success', esc_html__( 'Listing is successfully deleted.', 'urbango-listing' ) );
				}
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'You don\'t have  permission to delete item.', 'urbango-listing' ) );
			}
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_delete_listing', 'urbango_listing_delete_listing' );
}

if ( ! function_exists( 'urbango_listing_get_add_listing_params' ) ) {
	function urbango_listing_get_add_listing_params() {
		$add_listing_params = array();
		$package_necessary  = urbango_edge_options()->getOptionValue( 'enable_packages_necessity' );
		
		if ( $package_necessary === 'no' ) {
			//if package is not necessary, featured items cannot be set by user, therefore is 0
			$add_listing_params['number_of_featured'] = 0;
		} else {
			$package_key        = urbango_listing_get_user_current_package();
			$number_of_featured = 0;
			
			if ( $package_key !== false ) {
				$package_info       = urbango_listing_get_package_info( $package_key );
				$number_of_featured = $package_info['featured_items_remaining'];
			}
			
			$add_listing_params['number_of_featured'] = $number_of_featured;
		}
		
		return $add_listing_params;
	}
}

if ( ! function_exists( 'urbango_listing_approved_user_roles' ) ) {
	function urbango_listing_approved_user_roles( $user_roles ) {
		$roles          = array();
		$approved_roles = apply_filters( 'urbango_listing_role_listing_filter', $roles );
		$approved       = false;
		
		foreach ( $approved_roles as $approved_role ) {
			if ( in_array( $approved_role, $user_roles ) ) {
				$approved = true;
				continue;
			}
		}
		
		return $approved;
	}
}

if ( ! function_exists( 'urbango_listing_check_is_package_available' ) ) {
	function urbango_listing_check_is_package_available() {
		$package_necessary = urbango_edge_options()->getOptionValue( 'enable_packages_necessity' );
		$enabled           = $package_necessary === 'no' ? true : urbango_listing_get_user_current_package();
		
		return $enabled;
	}
}
