(function ($) {
	'use strict';
	
	var listing = {};
	edgtf.modules.listing = listing;
	
	listing.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfDeleteListingItemFromDashboard();
	}
	
	function edgtfDeleteListingItemFromDashboard() {
		var button = $('.edgtf-listing-item-delete');
		
		if (button.length) {
			button.each(function () {
				var thisDeleteButton = $(this),
					listingId = thisDeleteButton.data('listing-id'),
					confirmText = thisDeleteButton.data('confirm-text'),
					listing = thisDeleteButton.parents('.edgtf-lp-listing-item');
				
				thisDeleteButton.on('click', function (e) {
					e.preventDefault();
					
					var confirmDelete = confirm(confirmText);
					
					if (confirmDelete) {
						var dataForm = {
							'action': 'urbango_listing_delete_listing',
							'listing_id': listingId
						};
						
						$.ajax({
							type: 'POST',
							data: dataForm,
							url: edgtfGlobalVars.vars.edgtfAjaxUrl,
							success: function (data) {
								var response = JSON.parse(data);
								
								if (response.status === 'success') {
									listing.fadeOut(function () {
										listing.remove();
									});
								}
							}
						});
					}
				});
			});
		}
	}
	
})(jQuery);