<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_item_social_share_option' ) ) {
	function urbango_listing_add_listing_item_social_share_option( $panel ) {
		urbango_edge_add_admin_field(
			array(
				'name'          => 'enable_social_share_on_listing_item',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Listing Item', 'urbango-listing' ),
				'description'   => esc_html__( 'Show Social Share for Listing Items', 'urbango-listing' ),
				'parent'        => $panel
			)
		);
	}
	
	add_action( 'urbango_edge_action_post_types_social_share', 'urbango_listing_add_listing_item_social_share_option' );
}
