<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_listing_single_meta_boxes' ) ) {
	function urbango_listing_add_listing_single_meta_boxes() {
		
		
		// General meta box section - begin
		
		$general_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'listing-item',
				'title' => esc_html__( 'General Listing Section', 'urbango-listing' ),
				'name'  => 'listing_single_general_meta_box'
			)
		);
		
		if ( urbango_listing_check_if_user_has_featured_items() || urbango_listing_check_is_user_admin() ) {
			urbango_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_listing_is_featured_meta',
					'type'          => 'yesno',
					'default_value' => 'no',
					'label'         => esc_html__( 'Listing Is Featured', 'urbango-listing' ),
					'parent'        => $general_box,
					'args'          => array(
						'select2' => true
					)
				)
			);
		}
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_listing_id_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Listing ID', 'urbango-listing' ),
				'parent' => $general_box,
				'args'   => array(
					'col_width'    => 3
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_title_logo_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Title Logo', 'urbango-listing' ),
				'description' => esc_html__( 'Choose an title logo image for listing single page', 'urbango-listing' ),
				'parent'      => $general_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_listing_single_price_range_meta',
				'type'          => 'select',
				'default_value' => '3',
				'label'         => esc_html__( 'Price Range', 'urbango-listing' ),
				'options'       => urbango_listing_get_listing_price_range(),
				'parent'        => $general_box
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_general_meta_boxes', $general_box );
		
		// General meta box section - end
		
		// Gallery meta box section - begin
		
		$gallery_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'listing-item',
				'name'  => 'listing_single_gallery_meta_box',
				'title' => esc_html__( 'Gallery Section', 'urbango-listing' )
			)
		);
		
		urbango_edge_add_multiple_images_field(
			array(
				'name'          => 'edgtf_listing_single_gallery_images_meta',
				'label'         => esc_html__( 'Gallery Images', 'urbango-listing' ),
				'description'   => esc_html__( 'Choose your gallery images for listing single page', 'urbango-listing' ),
				'parent'        => $gallery_box
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_gallery_meta_boxes', $gallery_box );
		
		// Gallery meta box section - end
		
		// Location meta box section - begin
		
		$location_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'listing-item',
				'name'  => 'listing_single_location_meta_box',
				'title' => esc_html__( 'Location Section', 'urbango-listing' )
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_single_location_address_info',
				'title'  => esc_html__( 'Address Information', 'urbango-listing' ),
				'parent' => $location_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_listing_single_full_address_meta',
				'type'   => 'address',
				'label'  => esc_html__( 'Full Address', 'urbango-listing' ),
				'parent' => $location_box,
				'args'   => array(
					'latitude_field'  => 'edgtf_listing_single_full_address_latitude_meta',
					'longitude_field' => 'edgtf_listing_single_full_address_longitude_meta'
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_listing_single_full_address_latitude_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Latitude', 'urbango-listing' ),
				'parent' => $location_box,
				'args'   => array(
					'col_width'    => 3,
					'custom_class' => 'edgtf-address-elements',
					'input-data'   => array(
						'data-geo' => 'lat'
					)
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'   => 'edgtf_listing_single_full_address_longitude_meta',
				'type'   => 'text',
				'label'  => esc_html__( 'Longitude', 'urbango-listing' ),
				'parent' => $location_box,
				'args'   => array(
					'col_width'    => 3,
					'custom_class' => 'edgtf-address-elements',
					'input-data'   => array(
						'data-geo' => 'lng'
					)
				)
			)
		);
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_single_location_contact_info',
				'title'  => esc_html__( 'Contact Information', 'urbango-listing' ),
				'parent' => $location_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_phone_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Phone', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_email_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Email', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_site_url_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Site URL', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_location_address_meta_boxes', $location_box );
		
		urbango_edge_add_admin_section_title(
			array(
				'name'   => 'listing_single_location_social_info',
				'title'  => esc_html__( 'Social Information', 'urbango-listing' ),
				'parent' => $location_box
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_facebook_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Facebook Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_twitter_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Twiiter Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_instagram_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Instagram Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_tripadvisor_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Tripadvisor Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_youtube_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'YouTube Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_google_plus_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Google+ Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_pinterest_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Pinterest Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'        => 'edgtf_listing_single_contact_yelp_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Yelp Link', 'urbango-listing' ),
				'parent'      => $location_box,
				'args'        => array(
					'col_width' => 6
				)
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_location_social_meta_boxes', $location_box );
		
		// Location meta box section - end
		
		// Amenity meta box section - begin
		
		$amenities = urbango_listing_get_cpt_taxonomy_items( 'amenity', false );
		
		if ( ! empty( $amenities ) ) {
			
			$amenity_box = urbango_edge_create_meta_box(
				array(
					'scope' => 'listing-item',
					'name'  => 'listing_single_amenity_meta_box',
					'title' => esc_html__( 'Amenity Section', 'urbango-listing' )
				)
			);
			
			urbango_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_listing_single_included_amenities_meta',
					'type'          => 'checkboxgroup',
					'default_value' => '',
					'label'         => esc_html__( 'Included Amenities', 'urbango-listing' ),
					'description'   => esc_html__( 'Define included amenities for listing single page', 'urbango-listing' ),
					'options'       => $amenities,
					'parent'        => $amenity_box
				)
			);
			
			urbango_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_listing_single_excluded_amenities_meta',
					'type'          => 'checkboxgroup',
					'default_value' => '',
					'label'         => esc_html__( 'Excluded Amenities', 'urbango-listing' ),
					'description'   => esc_html__( 'Define excluded amenities for listing single page', 'urbango-listing' ),
					'options'       => $amenities,
					'parent'        => $amenity_box
				)
			);
			
			do_action( 'urbango_listing_action_additional_listing_single_amenity_meta_boxes', $amenity_box );
		}
		
		// Amenity meta box section - end
		
		// Open Table meta box section - begin
		
		if ( urbango_listing_check_is_listing_open_table_allowed() ) {
			
			$open_table_box = urbango_edge_create_meta_box(
				array(
					'scope' => 'listing-item',
					'name'  => 'listing_single_open_table_meta_box',
					'title' => esc_html__( 'Open Table Section', 'urbango-listing' )
				)
			);
			
			urbango_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_listing_single_open_table_id_meta',
					'type'        => 'text',
					'label'       => esc_html__( 'Open Table ID', 'urbango-listing' ),
					'description' => esc_html__( 'Add your OpenTable ID for the listing single page', 'urbango-listing' ),
					'parent'      => $open_table_box,
					'args'        => array(
						'col_width' => 3
					)
				)
			);
			
			do_action( 'urbango_listing_action_additional_listing_single_open_table_meta_boxes', $open_table_box );
		}
		
		// Open Table meta box section - end
		
		// Reviews Criteria meta box section - begin
		
		$reviews_criteria = urbango_listing_get_cpt_taxonomy_items( 'reviews-criteria' );
		
		if ( ! empty( $reviews_criteria ) ) {
			
			$reviews_criteria_box = urbango_edge_create_meta_box(
				array(
					'scope' => 'listing-item',
					'name'  => 'listing_single_reviews_criteria_meta_box',
					'title' => esc_html__( 'Reviews Criteria Section', 'urbango-listing' )
				)
			);
			
			urbango_edge_create_meta_box_field(
				array(
					'name'          => 'edgtf_listing_single_reviews_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Reviews', 'urbango-listing' ),
					'description'   => esc_html__( 'Enabling this option will show reviews on listing single page', 'urbango-listing' ),
					'options'       => urbango_edge_get_yes_no_select_array(),
					'parent'        => $reviews_criteria_box
				)
			);
			
			urbango_edge_create_meta_box_field(
				array(
					'name'        => 'edgtf_listing_single_advanced_reviews_meta',
					'type'        => 'select',
					'label'       => esc_html__( 'Enable Advanced Reviews', 'urbango-listing' ),
					'description' => esc_html__( 'Enabling this option will show advanced reviews criteria in reviews on listing single page', 'urbango-listing' ),
					'options'     => urbango_edge_get_yes_no_select_array(),
					'parent'      => $reviews_criteria_box,
					'dependency'  => array(
						'show' => array(
							'edgtf_listing_single_reviews_meta' => array( '', 'yes' )
						)
					)
				)
			);
			
			do_action( 'urbango_listing_action_additional_listing_single_reviews_criteria_meta_boxes', $reviews_criteria_box );
		}
		
		// Reviews Criteria meta box section - end
		
		// Business Hours meta box section - begin
		
		$business_hours_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'listing-item',
				'name'  => 'listing_single_business_hours_meta_box',
				'title' => esc_html__( 'Business Hours Section', 'urbango-listing' )
			)
		);
		
		urbango_edge_create_meta_box_field(
			array(
				'name'          => 'edgtf_listing_single_business_hours_time_zone_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Date Time Zone', 'urbango-listing' ),
				'description'   => esc_html__( 'Choose your time zone for setting your business hours time', 'urbango-listing' ),
				'options'       => urbango_listing_get_date_time_zone(),
				'parent'        => $business_hours_box,
				'args'          => array(
					'select2' => true
				)
			)
		);
		
		urbango_edge_add_repeater_field(
			array(
				'name'        => 'edgtf_listing_single_business_hours_meta',
				'button_text' => '',
				'parent'      => $business_hours_box,
				'fields'      => array(
					array(
						'name'      => 'day',
						'type'      => 'select',
						'label'     => esc_html__( 'Day', 'urbango-listing' ),
						'options'   => urbango_listing_get_weekend_days(),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'open_time',
						'type'      => 'select',
						'label'     => esc_html__( 'Open Time', 'urbango-listing' ),
						'options'   => urbango_listing_get_hours_range(),
						'col_width' => '2',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'end_time',
						'type'      => 'select',
						'label'     => esc_html__( 'End Time', 'urbango-listing' ),
						'options'   => urbango_listing_get_hours_range(),
						'col_width' => '2',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => '24h_open',
						'type'      => 'select',
						'label'     => esc_html__( '24 Hours', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '2',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'closed',
						'type'      => 'select',
						'label'     => esc_html__( 'Closed', 'urbango-listing' ),
						'options'   => urbango_edge_get_yes_no_select_array( false ),
						'col_width' => '2',
						'args'      => array(
							'col_width' => 12
						)
					)
				)
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_business_hours_meta_boxes', $business_hours_box );
		
		// Business Hours meta box section - end
		
		// Additional Info meta box section - begin
		
		$additional_info_box = urbango_edge_create_meta_box(
			array(
				'scope' => 'listing-item',
				'name'  => 'listing_single_additional_info_meta_box',
				'title' => esc_html__( 'Additional Info Section', 'urbango-listing' )
			)
		);
		
		urbango_edge_add_repeater_field(
			array(
				'name'        => 'edgtf_listing_single_additional_info_meta',
				'button_text' => '',
				'parent'      => $additional_info_box,
				'fields'      => array(
					array(
						'name'      => 'label',
						'type'      => 'text',
						'label'     => esc_html__( 'Label', 'urbango-listing' ),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'value',
						'type'      => 'text',
						'label'     => esc_html__( 'Value', 'urbango-listing' ),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					),
					array(
						'name'      => 'value_link',
						'type'      => 'text',
						'label'     => esc_html__( 'Value Link', 'urbango-listing' ),
						'col_width' => '4',
						'args'      => array(
							'col_width' => 12
						)
					)
				)
			)
		);
		
		do_action( 'urbango_listing_action_additional_listing_single_additional_info_meta_boxes', $additional_info_box );
		
		// Additional Info meta box section - end
		
	}
	
	add_action( 'urbango_edge_action_meta_boxes_map', 'urbango_listing_add_listing_single_meta_boxes', 1 );
}
