<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_allow_claim_cpt_for_meta_box_functions' ) ) {
	function urbango_listing_allow_claim_cpt_for_meta_box_functions( $post_types ) {
		$post_types[] = 'claim';
		
		return $post_types;
	}
	
	add_filter( 'urbango_edge_filter_meta_box_post_types_save', 'urbango_listing_allow_claim_cpt_for_meta_box_functions' );
	add_filter( 'urbango_edge_filter_meta_box_post_types_remove', 'urbango_listing_allow_claim_cpt_for_meta_box_functions' );
}

if ( ! function_exists( 'urbango_listing_register_claim_custom_post_types' ) ) {
	function urbango_listing_register_claim_custom_post_types( $cpt_classes ) {
		$cpt_class = array(
			'UrbanGoListing\CPT\Claim\ClaimRegister'
		);
		
		return array_merge( $cpt_classes, $cpt_class );
	}
	
	add_filter( 'urbango_listing_filter_register_custom_post_types', 'urbango_listing_register_claim_custom_post_types' );
}

if ( ! function_exists( 'urbango_listing_get_listing_item_claim_form' ) ) {
	function urbango_listing_get_listing_item_claim_form() {
		$allowed_pages = apply_filters( 'urbango_listing_filter_allowed_claim_pages', array() );
		
		if ( ! empty( $allowed_pages ) && is_user_logged_in() ) {
			foreach ( $allowed_pages as $allowed_page ) {
				if ( is_singular( $allowed_page ) ) {
					urbango_listing_get_module_template_part( 'cpt', 'claim', 'templates/claim-form' );
				}
			}
		}
	}
	
	add_action( 'urbango_edge_action_before_page_header', 'urbango_listing_get_listing_item_claim_form' );
}

if ( ! function_exists( 'urbango_listing_get_user_claimed_items' ) ) {
	function urbango_listing_get_user_claimed_items() {
		$all_claims         = urbango_listing_get_cpt_items( 'claim' );
		$user_listings      = urbango_listing_get_cpt_items( 'listing-item', array( 'author' => get_current_user_id() ) );
		$user_claimed_items = array();
		
		if ( ! empty( $all_claims ) ) {
			foreach ( $all_claims as $id => $title ) {
				$claimed_listing = get_post_meta( $id, 'edgtf_listing_claimed_listing_item_id_meta', true );
				
				if ( ! empty( $claimed_listing ) && array_key_exists( intval( $claimed_listing ), $user_listings ) ) {
					$user_claimed_items[ $id ] = intval( $claimed_listing );
				}
			}
		}
		
		return $user_claimed_items;
	}
}

if ( ! function_exists( 'urbango_listing_send_listing_item_claim' ) ) {
	function urbango_listing_send_listing_item_claim() {
		if ( isset( $_POST['claimData'] ) ) {
			$error           = false;
			$responseMessage = '';
			
			$data  = $_POST['claimData'];
			$nonce = $data['nonce'];
			
			if ( wp_verify_nonce( $nonce, 'urbango_listing_validate_listing_item_claim_form' ) ) {
				
				// Validate input fields
				if ( empty( $data['itemID'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'Item ID is invalid.', 'urbango-listing' );
				}
				
				if ( empty( $data['userID'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'User is not logged in.', 'urbango-listing' );
				}
				
				if ( empty( $data['message'] ) ) {
					$error           = true;
					$responseMessage = esc_html__( 'Please enter a valid message.', 'urbango-listing' );
				}
				
				if ( $error ) {
					urbango_listing_get_ajax_status( 'error', $responseMessage );
				} else {
					// Get necessary variables
					$post_id = intval( esc_attr( $data['itemID'] ) );
					$user_id = intval( esc_attr( $data['userID'] ) );
					$message = esc_attr( esc_html( $data['message'] ) );
					
					// Check is user already claimed this item
					$already_claimed = false;
					
					$all_claims = urbango_listing_get_cpt_items( 'claim' );
					if ( ! empty( $all_claims ) ) {
						foreach ( $all_claims as $id => $title ) {
							$claimed_listing = get_post_meta( $id, 'edgtf_listing_claimed_listing_item_id_meta', true );
							$claimed_by_user = get_post_meta( $id, 'edgtf_listing_claimed_user_id_meta', true );
							
							if ( ! empty( $claimed_listing ) && intval( $claimed_listing ) === $post_id && ! empty( $claimed_by_user ) && intval( $claimed_by_user ) === $user_id ) {
								$already_claimed = true;
								$responseMessage = esc_html__( 'You already claimed this item.', 'urbango-listing' );
							}
						}
					}
					
					if ( $already_claimed ) {
						urbango_listing_get_ajax_status( 'error', $responseMessage );
					} else {
						$params               = array();
						$params['meta_input'] = array();
						
						$params['post_status'] = 'publish';
						$params['post_type']   = 'claim';
						$params['post_title']  = sprintf( esc_html__( '%s - %s', 'urbango-listing' ), get_the_title( $post_id ), get_the_author_meta( 'display_name', get_post_field('post_author', $post_id ) ) );
						
						$params['meta_input']['edgtf_listing_claimed_listing_item_id_meta']      = $post_id;
						$params['meta_input']['edgtf_listing_claimed_user_id_meta']              = $user_id;
						$params['meta_input']['edgtf_listing_claimed_user_claimed_message_meta'] = $message;
						
						$create_claim = wp_insert_post( $params );
						
						if ( ! is_wp_error( $create_claim ) ) {
							// Remove data from global post variable after submission
							unset( $_POST['claimData'] );
							
							urbango_listing_get_ajax_status( 'success', esc_html__( 'Claim is successfully sent.', 'urbango-listing' ) );
						} else {
							urbango_listing_get_ajax_status( 'error', esc_html__( 'Error while creating claim.', 'urbango-listing' ) );
						}
					}
				}
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Nonce is invalid.', 'urbango-listing' ) );
			}
		} else {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Claim is not valid please try again to send it.', 'urbango-listing' ) );
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_send_listing_item_claim', 'urbango_listing_send_listing_item_claim' );
}
