<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_register_wishlist_dropdown_widget' ) ) {
	/**
	 * Function that register widget
	 */
	function urbango_listing_register_wishlist_dropdown_widget( $widgets ) {
		$widgets[] = 'UrbanGoListingWishlistDropdown';
		
		return $widgets;
	}
	
	add_filter( 'urbango_edge_filter_register_widgets', 'urbango_listing_register_wishlist_dropdown_widget' );
}

if ( ! function_exists( 'urbango_listing_update_wishlist_dropdown_widget' ) ) {
	function urbango_listing_update_wishlist_dropdown_widget() {
		
		if ( ! is_user_logged_in() ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'User is not logged in.', 'urbango-listing' ) );
		} else if ( isset( $_POST['wishlistData'] ) ) {
			$data    = $_POST['wishlistData'];
			$item_id = $data['itemID'];
			
			if ( ! empty( $item_id ) ) {
				$count = urbango_listing_get_number_of_wishlist_items();
				
				ob_clean();
				
				$item_params          = array();
				$item_params['id']    = $item_id;
				$item_params['title'] = get_the_title( $item_id );
				
				urbango_listing_get_module_template_part( 'modules', 'wishlist', 'widgets/wishlist-dropdown/templates/wishlist-dropdown-item', '', $item_params );
				
				$new_html = ob_get_contents();
				
				ob_end_clean();
				
				urbango_listing_get_ajax_status( 'success', esc_html__( 'Updated', 'urbango-listing' ), array(
					'count'    => $count,
					'new_html' => $new_html
				) );
				
				unset( $_POST['wishlistData'] ); // Remove data from global post variable after submission
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Item ID is invalid.', 'urbango-listing' ) );
			}
		} else {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Something was wrong.', 'urbango-listing' ) );
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_update_wishlist_dropdown_widget', 'urbango_listing_update_wishlist_dropdown_widget' );
}
