<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

$wishlist_items = urbango_listing_get_wishlist_items();
?>
<div class="edgtf-listing-profile-wishlist">
	<?php if ( ! empty( $wishlist_items ) ) { ?>
		<div class="edgtf-lp-section-title">
			<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'My Wishlist', 'urbango-listing' ); ?></h3>
			<p class="edgtf-lp-st-text"><?php esc_html_e( 'Manage your wishlist in this section and see which listings you have added to the wishlist.', 'urbango-listing' ); ?></p>
		</div>
		<?php
		$included_items = array();
		foreach ( $wishlist_items as $id => $title ) {
			$included_items[] = $id;
		}
		
		if ( ! empty( $included_items ) ) {
			$shortcode_params = array(
				'number_of_columns' => 'four',
				'selected_items'    => implode( ',', $included_items ),
				'enable_excerpt'    => 'no'
			);
			
			echo urbango_edge_execute_shortcode( 'edgtf_listing_list', apply_filters( 'urbango_listing_filter_wishlist_profile_page_params', $shortcode_params ) );
		}
	} else { ?>
		<h3 class="edgtf-lp-not-found"><?php esc_html_e( 'Your wishlist is empty.', 'urbango-listing' ); ?> </h3>
	<?php } ?>
</div>