<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_load_wishlist_widgets' ) ) {
	function urbango_listing_load_wishlist_widgets() {
		if ( urbango_listing_is_core_plugin_installed() ) {
			foreach ( glob( URBANGO_LISTING_MODULES_PATH . '/wishlist/widgets/*/load.php' ) as $file ) {
				include_once $file;
			}
		}
	}

	add_action( 'after_setup_theme', 'urbango_listing_load_wishlist_widgets' ); // hook need to be after_setup_theme or some early because of widgets loading
}

if ( ! function_exists( 'urbango_listing_wishlist_ajax_functionality' ) ) {
	function urbango_listing_wishlist_ajax_functionality() {

		if ( ! is_user_logged_in() ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'User is not logged in.', 'urbango-listing' ) );
		} else if ( isset( $_POST['wishlistData'] ) ) {
			$error           = false;
			$responseMessage = '';

			$data   = $_POST['wishlistData'];
			$type   = $data['type'];
			$itemID = $data['itemID'];

			// Validate fields
			if ( empty( $itemID ) ) {
				$error           = true;
				$responseMessage = esc_html__( 'Item ID is invalid.', 'urbango-listing' );
			}

			// Update user meta
			if ( $error ) {
				urbango_listing_get_ajax_status( 'error', $responseMessage );
			} else {
				$user_id   = get_current_user_id();
				$user_meta = get_user_meta( $user_id, 'edgtf_user_wishlist_items', true );

				if ( $type === 'add' ) {

					if ( ! isset( $user_meta ) || empty( $user_meta ) ) {
						$user_meta = array();
					}

					$user_meta[ $itemID ] = get_the_title( $itemID );

					update_user_meta( $user_id, 'edgtf_user_wishlist_items', $user_meta );

					urbango_listing_get_ajax_status( 'success', esc_html__( 'Item is added', 'urbango-listing' ) );

				} else if ( $type === 'remove' ) {

					if ( ! empty( $user_meta ) && isset( $user_meta[ $itemID ] ) ) {
						unset( $user_meta[ $itemID ] );

						update_user_meta( $user_id, 'edgtf_user_wishlist_items', $user_meta );

						$count = urbango_listing_get_number_of_wishlist_items();

						urbango_listing_get_ajax_status( 'success', esc_html__( 'Removed', 'urbango-listing' ), array(
							'count' => $count
						) );
					} else {
						urbango_listing_get_ajax_status( 'error', esc_html__( 'User meta is empty.', 'urbango-listing' ) );
					}
				}

				unset( $_POST['wishlistData'] ); // Remove data from global post variable after submission
			}
		} else {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Something was wrong.', 'urbango-listing' ) );
		}
	}

	add_action( 'wp_ajax_urbango_listing_wishlist_ajax_functionality', 'urbango_listing_wishlist_ajax_functionality' );
}

if ( ! function_exists( 'urbango_listing_get_wishlist_items' ) ) {
	function urbango_listing_get_wishlist_items() {
		$items = array();

		if ( is_user_logged_in() ) {
			$wishlist_items = get_user_meta( get_current_user_id(), 'edgtf_user_wishlist_items', true );

			if ( isset( $wishlist_items ) && ! empty( $wishlist_items ) ) {
				$items = $wishlist_items;
			}
		}

		return $items;
	}
}

if ( ! function_exists( 'urbango_listing_get_number_of_wishlist_items' ) ) {
	function urbango_listing_get_number_of_wishlist_items() {
		$count = 0;

		if ( is_user_logged_in() ) {
			$wishlist_items = get_user_meta( get_current_user_id(), 'edgtf_user_wishlist_items', true );

			if ( isset( $wishlist_items ) && ! empty( $wishlist_items ) ) {
				$count = intval( count( $wishlist_items ) );
			}
		}

		return $count;
	}
}
