(function ($) {
	'use strict';
	
	var wishlist = {};
	edgtf.modules.wishlist = wishlist;
	
	wishlist.edgtfOnDocumentReady = edgtfOnDocumentReady;
	
	$(document).ready(edgtfOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function edgtfOnDocumentReady() {
		edgtfInitWishlist();
	}
	
	/**
	 * Initializes wishlist functionality
	 */
	function edgtfInitWishlist() {
		var wishlistLink = $('.edgtf-wishlist-holder .edgtf-wishlist-link');
		
		if (wishlistLink.length) {
			wishlistLink.each(function(){
				var thisWishlistLink = $(this),
					wishlistIconHTML = thisWishlistLink.html(),
					responseMessage = thisWishlistLink.siblings('.edgtf-wishlist-response');
			
				thisWishlistLink.off().on('click', function (e) {
					e.preventDefault();
					
					if (edgtf.body.hasClass('logged-in')) {
						var itemID = thisWishlistLink.data('id');
						
						if (itemID !== 'undefined' && !thisWishlistLink.hasClass('edgtf-added')) {
							thisWishlistLink.html('<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>');
							
							$.ajax({
								type: "POST",
								url: edgtfGlobalVars.vars.edgtfAjaxUrl,
								data: {
									action: 'urbango_listing_wishlist_ajax_functionality',
									wishlistData: {
										type: 'add',
										itemID: itemID
									}
								},
								success: function (data) {
									var response = JSON.parse(data);
									
									if (response.status === 'success') {
										thisWishlistLink.addClass('edgtf-added');
										responseMessage.html(response.message).addClass('edgtf-show').fadeIn(200);
										
										$(document).trigger('urbango_listing_wishlist_item_is_added', [itemID]);
									} else {
										responseMessage.html(response.message).addClass('edgtf-show').fadeIn(200);
									}
									
									setTimeout(function () {
										thisWishlistLink.html(wishlistIconHTML);
										
										var wishlistTitle = thisWishlistLink.find('.edgtf-wishlist-title');
										
										if (wishlistTitle.length) {
											wishlistTitle.text(wishlistTitle.data('added-title'));
										}
										
										responseMessage.fadeOut(300).removeClass('edgtf-show').empty();
									}, 800);
								}
							});
						}
					} else {
						// Trigger event.
						$(document.body).trigger('open_user_login_trigger');
					}
				});
			});
		}
	}
	
	$(document).on('urbango_listing_wishlist_item_is_removed', function (e, removedItemID) {
		var wishlistLink = $('.edgtf-wishlist-holder .edgtf-wishlist-link');
		
		if (wishlistLink.length) {
			wishlistLink.each(function(){
				var thisWishlistLink = $(this),
					wishlistTitle = thisWishlistLink.find('.edgtf-wishlist-title');
			
				if (thisWishlistLink.data('id') === removedItemID && thisWishlistLink.hasClass('edgtf-added')) {
					thisWishlistLink.removeClass('edgtf-added');
				
					if (wishlistTitle.length) {
						wishlistTitle.text(wishlistTitle.data('title'));
					}
				}
			});
		}
	});
	
})(jQuery);