<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_dashboard_edit_owner_fields' ) ) {
	function urbango_listing_dashboard_edit_owner_fields( $params ) {
		extract( $params );
		
		$edit_owner = urbango_edge_add_dashboard_fields(
			array(
				'name' => 'edit_owner',
			)
		);
		
		$edit_owner_form = urbango_edge_add_dashboard_form(
			array(
				'name'         => 'edit_owner_form',
				'form_id'      => 'edgtf-listing-update-owner-profile-form',
				'form_action'  => 'urbango_listing_update_owner_profile',
				'parent'       => $edit_owner,
				'button_label' => esc_html__( 'Update Profile', 'urbango-listing' ),
				'button_args'  => array(
					'data-updating-text' => esc_html__( 'Updating Profile', 'urbango-listing' ),
					'data-updated-text'  => esc_html__( 'Profile Updated', 'urbango-listing' ),
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'first_name',
				'label'  => esc_html__( 'First Name', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $first_name
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'last_name',
				'label'  => esc_html__( 'Last Name', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $last_name
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'image',
				'name'   => 'edgtf_owner_profile_image',
				'label'  => esc_html__( 'Profile Image', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $edgtf_owner_profile_image
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'email',
				'label'  => esc_html__( 'Email', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $email,
				'args'   => array(
					'input_type' => 'email'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'url',
				'label'  => esc_html__( 'Website', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $website
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'edgtf_owner_telephone',
				'label'  => esc_html__( 'Telephone', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $edgtf_owner_telephone
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'edgtf_owner_mobile_phone',
				'label'  => esc_html__( 'Mobile Phone', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $edgtf_owner_mobile_phone
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'edgtf_owner_fax_number',
				'label'  => esc_html__( 'Fax Number', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $edgtf_owner_fax_number
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'edgtf_owner_address',
				'label'  => esc_html__( 'Address', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $edgtf_owner_address
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'textarea',
				'name'   => 'description',
				'label'  => esc_html__( 'Description', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'value'  => $description
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'password',
				'label'  => esc_html__( 'Password', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'args'   => array(
					'input_type' => 'password'
				)
			)
		);
		
		urbango_edge_add_dashboard_field(
			array(
				'type'   => 'text',
				'name'   => 'password2',
				'label'  => esc_html__( 'Repeat Password', 'urbango-listing' ),
				'parent' => $edit_owner_form,
				'args'   => array(
					'input_type' => 'password'
				)
			)
		);
		
		$edit_owner->render();
	}
}
?>

<div class="edgtf-dashboard-page">
	<div class="edgtf-lp-section-title">
		<h3 class="edgtf-lp-st-title"><?php esc_html_e( 'Edit Your Profile', 'urbango-listing' ); ?></h3>
		<p class="edgtf-lp-st-text"><?php esc_html_e( 'This is where you can add and change your profile information, including your name, description and password.', 'urbango-listing' ); ?></p>
	</div>
	<div>
		<?php urbango_listing_dashboard_edit_owner_fields( $params ); ?>
		<?php do_action( 'urbango_membership_action_login_ajax_response' ); ?>
	</div>
</div>