<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_owner_role_approved_filter' ) ) {
	function urbango_listing_owner_role_approved_filter( $approved_roles ) {
		$owner_approved = urbango_edge_options()->getOptionValue( 'listing_owner_adding_listing_item' );
		
		if ( $owner_approved === 'yes' ) {
			$approved_roles[] = 'owner';
		}
		
		return $approved_roles;
	}
	
	add_filter( 'urbango_listing_role_listing_filter', 'urbango_listing_owner_role_approved_filter' );
}

if ( ! function_exists( 'urbango_listing_add_owner_pages' ) ) {
	function urbango_listing_add_owner_pages( $page, $action ) {
		$user = wp_get_current_user();
		
		if ( $action == 'profile' && in_array( 'owner', $user->roles ) ) {
			$owner_params = urbango_listing_get_owner_params();
			$page         = urbango_listing_get_module_template_part( 'modules', 'roles', 'owner/templates/profile', '', $owner_params, array(), false );
		} else if ( $action == 'edit-profile' && in_array( 'owner', $user->roles ) ) {
			$owner_params = urbango_listing_get_owner_params();
			$page         = urbango_listing_get_module_template_part( 'modules', 'roles', 'owner/templates/edit-profile', '', $owner_params, array(), false );
		}
		
		return $page;
	}
	
	add_filter( 'urbango_membership_dashboard_pages', 'urbango_listing_add_owner_pages', 10, 2 );
}

if ( ! function_exists( 'urbango_listing_update_owner_profile' ) ) {
	function urbango_listing_update_owner_profile() {
		
		if ( empty( $_POST ) || ! isset( $_POST ) ) {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'All fields are empty', 'urbango-listing' ) );
		} else {
			$dashboard_url = urbango_listing_is_membership_plugin_installed() ? urbango_membership_get_dashboard_page_url() : '#';
			parse_str( $_POST['data'], $update_data );
			
			$user_id = get_current_user_id();
			
			$nonce_name  = 'edgtf_validate_' . $update_data['edgtf_form_name'] . '_' . $user_id;
			$nonce_value = 'edgtf_nonce_' . $update_data['edgtf_form_name'] . '_' . $user_id;
			
			//Check nonce
			if ( wp_verify_nonce( $update_data[ $nonce_value ], $nonce_name ) ) {
				if ( $user_id ) {
					
					//Update password
					if ( ! empty( $update_data['password'] ) ) {
						if ( $update_data['password'] === $update_data['password2'] ) {
							wp_update_user( array(
								'ID'        => $user_id,
								'user_pass' => esc_attr( $update_data['password'] )
							) );
						} else {
							urbango_listing_get_ajax_status( 'error', esc_html__( 'Passwords don\'t match', 'urbango-listing' ) );
						}
					}
					
					//Update email
					if ( ! empty( $update_data['email'] ) && filter_var( $update_data['email'], FILTER_VALIDATE_EMAIL ) ) {
						wp_update_user( array( 'ID' => $user_id, 'user_email' => esc_attr( $update_data['email'] ) ) );
					} else {
						urbango_listing_get_ajax_status( 'error', esc_html__( 'Error. Please insert valid email', 'urbango-listing' ) );
					}
					
					//Update Website
					wp_update_user( array( 'ID' => $user_id, 'user_url' => esc_url( $update_data['url'] ) ) );
					
					//Update user meta
					update_user_meta( $user_id, 'first_name', $update_data['first_name'] );
					update_user_meta( $user_id, 'last_name', $update_data['last_name'] );
					update_user_meta( $user_id, 'edgtf_owner_telephone', $update_data['edgtf_owner_telephone'] );
					update_user_meta( $user_id, 'edgtf_owner_mobile_phone', $update_data['edgtf_owner_mobile_phone'] );
					update_user_meta( $user_id, 'edgtf_owner_fax_number', $update_data['edgtf_owner_fax_number'] );
					update_user_meta( $user_id, 'edgtf_owner_address', $update_data['edgtf_owner_address'] );
					update_user_meta( $user_id, 'description', $update_data['description'] );
					
					//get media values (needed to be in input hidden because of the repeater values) - if empty then media is removed
					$owner_profile_image_db = $update_data['hidden_edgtf_owner_profile_image'];
					
					if ( $owner_profile_image_db == '' ) {
						update_user_meta( $user_id, 'edgtf_owner_profile_image', '' );
					}
					
					foreach ( $_FILES as $key => $value ) {
						$name = '';
						
						if ( stripos( $key, '_edgtf_reg_' ) ) {
							$lastLetterPos = stripos( $key, '_edgtf_reg_' );
							$name          = substr( $key, 0, $lastLetterPos );
						}
						
						if ( $value['name'] == 'edgtf-dummy-file.txt' ) {
							$attachment_id  = '';
							continue;
						} else {
							$attachment_id  = media_handle_upload( $key, 0 );
						}
						
						if ( is_wp_error( $attachment_id ) ) {
							urbango_listing_get_ajax_status( 'error', esc_html__( 'Media not uploaded, please try again.', 'urbango-listing' ) );
						} else {
							switch ( $name ) {
								case 'edgtf_owner_profile_image':
									update_user_meta( $user_id, 'edgtf_owner_profile_image', $attachment_id );
									break;
							}
						}
					}
					
					// Remove data from global post variable after submission
					unset( $_POST['data'] );
					
					urbango_listing_get_ajax_status( 'success', esc_html__( 'Your profile is updated', 'urbango-listing' ), null, $dashboard_url );
					
				} else {
					urbango_listing_get_ajax_status( 'error', esc_html__( 'You are unauthorized to perform this action.', 'urbango-listing' ) );
				}
				
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Error.', 'urbango-listing' ) );
			}
		}
	}
	
	add_action( 'wp_ajax_urbango_listing_update_owner_profile', 'urbango_listing_update_owner_profile' );
}

if ( ! function_exists( 'urbango_listing_get_owner_params' ) ) {
	/**
	 * Returns owner params
	 *
	 */
	function urbango_listing_get_owner_params() {
		$params = array();
		
		$user_id = get_current_user_id();
		
		$params['first_name']                = get_the_author_meta( 'first_name', $user_id );
		$params['last_name']                 = get_the_author_meta( 'last_name', $user_id );
		$params['email']                     = get_the_author_meta( 'user_email', $user_id );
		$params['website']                   = get_the_author_meta( 'user_url', $user_id );
		$params['description']               = get_the_author_meta( 'description', $user_id );
		$params['edgtf_owner_telephone']     = get_user_meta( $user_id, 'edgtf_owner_telephone', true );
		$params['edgtf_owner_mobile_phone']  = get_user_meta( $user_id, 'edgtf_owner_mobile_phone', true );
		$params['edgtf_owner_fax_number']    = get_user_meta( $user_id, 'edgtf_owner_fax_number', true );
		$params['edgtf_owner_address']       = get_user_meta( $user_id, 'edgtf_owner_address', true );
		$params['edgtf_owner_profile_image'] = get_user_meta( $user_id, 'edgtf_owner_profile_image', true );
		$profile_image                       = get_user_meta( $user_id, 'social_profile_image', true );
	
		if ( isset( $params['edgtf_owner_profile_image'] ) && $params['edgtf_owner_profile_image'] !== '' ) {
			$profile_image = wp_get_attachment_image( $params['edgtf_owner_profile_image'], 'medium' );
		} elseif ( $profile_image !== '' ) {
			$profile_image = '<img src="' . esc_url( $profile_image ) . '" alt="' . esc_attr__( 'Owner Profile Image', 'urbango-listing' ) . '">';
		} else {
			$profile_image = get_avatar( $user_id, 288 );
		}
		
		$params['profile_image'] = $profile_image;
		
		$user_social_array    = array();
		$social_network_array = array(
			'facebook',
			'twitter',
			'linkedin',
			'instagram',
			'pinterest',
			'tumblr',
			'googleplus'
		);
		
		foreach ( $social_network_array as $network ) {
			if ( get_user_meta( $user_id, $network, true ) !== '' ) {
				$$network                      = array(
					'link'  => get_user_meta( $user_id, $network, true ),
					'class' => 'social_' . $network
				);
				
				$user_social_array[ $network ] = $$network;
			}
		}
		
		$params['profile_socials'] = $user_social_array;
		
		return $params;
	}
}

if ( ! function_exists( 'urbango_listing_get_user_owner_options' ) ) {
	function urbango_listing_get_user_owner_options() {
		$owners_array = array();
		
		$owners = get_users( array( 'role' => 'owner' ) );
		
		foreach ( $owners as $owner ) {
			$owners_array[ $owner->ID ] = $owner->user_nicename;
		}
		
		return $owners_array;
	}
}
