<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_owner_meta_options' ) ) {
	function urbango_listing_owner_meta_options() {
		
		$owner_fields = urbango_edge_add_user_fields(
			array(
				'scope' => array( 'owner' ),
				'name'  => 'owner_fields'
			)
		);
		
		$owner_group = urbango_edge_add_user_group(
			array(
				'name'   => 'owner_group',
				'title'  => esc_html__( 'Owner Info', 'urbango-listing' ),
				'parent' => $owner_fields
			)
		);
		
		urbango_edge_add_user_field(
			array(
				'name'   => 'edgtf_owner_profile_image',
				'type'   => 'image',
				'label'  => esc_html__( 'Owner Profile Image', 'urbango-listing' ),
				'parent' => $owner_group
			)
		);
		
		urbango_edge_add_user_field(
			array(
				'name'   => 'edgtf_owner_telephone',
				'type'   => 'text',
				'label'  => esc_html__( 'Owner Telephone', 'urbango-listing' ),
				'parent' => $owner_group
			)
		);
		
		urbango_edge_add_user_field(
			array(
				'name'   => 'edgtf_owner_mobile_phone',
				'type'   => 'text',
				'label'  => esc_html__( 'Owner Mobile Phone', 'urbango-listing' ),
				'parent' => $owner_group
			)
		);
		
		urbango_edge_add_user_field(
			array(
				'name'   => 'edgtf_owner_fax_number',
				'type'   => 'text',
				'label'  => esc_html__( 'Owner Fax Number', 'urbango-listing' ),
				'parent' => $owner_group
			)
		);
		
		urbango_edge_add_user_field(
			array(
				'name'   => 'edgtf_owner_address',
				'type'   => 'text',
				'label'  => esc_html__( 'Owner Address', 'urbango-listing' ),
				'parent' => $owner_group
			)
		);
	}
	
	add_action( 'urbango_edge_action_custom_user_fields', 'urbango_listing_owner_meta_options' );
}
