<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_add_user_owner_role' ) ) {
	function urbango_listing_add_user_owner_role() {
		$capabilities = array(
			'read'                 => true,
			'publish_posts'        => true,
			'create_posts'         => true,
			'edit_posts'           => true,
			'edit_published_posts' => true,
			'edit_others_posts'    => false,
			'edit_pages'           => false,
			'manage_categories'    => false,
			'edit_themes'          => false,
			'install_plugins'      => false,
			'update_plugin'        => false,
			'edit_plugins'         => false,
			'update_core'          => false,
			'upload_files'         => true,
			'edit_files'           => false
		);
		
		add_role( 'owner', esc_html__( 'Owner/Buyer', 'urbango-listing' ), $capabilities );
		
		update_option( 'default_role', 'owner' );
	}
	
	add_action( 'urbango_listing_action_activation_plugin', 'urbango_listing_add_user_owner_role' );
}
