<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_include_roles_files' ) ) {
	/**
	 * Loads all roles types by going through all folders that are placed directly in roles folder
	 */
	function urbango_listing_include_roles_files() {
		if ( urbango_listing_is_theme_installed() ) {
			foreach ( glob( URBANGO_LISTING_MODULES_PATH . '/roles/*/load.php' ) as $file ) {
				include_once $file;
			}
		}
	}
	
	add_action( 'after_setup_theme', 'urbango_listing_include_roles_files', 1 );
}

if ( ! function_exists( 'urbango_listing_listing_role_called' ) ) {
	function urbango_listing_listing_role_called() {
		$role_called = false;
		
		if ( is_author() ) {
			$author = get_user_by( 'slug', get_query_var( 'author_name' ) );
			$roles  = $author->roles;
			
			if ( in_array( 'owner', $roles ) ) {
				$role_called = true;
			}
		}
		
		return $role_called;
	}
}

if ( ! function_exists( 'urbango_listing_user_set_registration_role' ) ) {
	function urbango_listing_user_set_registration_role( $default_role ) {
		$role_enable_meta = urbango_edge_options()->getOptionValue( 'listing_registration_role_enabled' );

		if ( $role_enable_meta ) {
			$owner_role_meta = urbango_edge_options()->getOptionValue( 'listing_enable_owner_role' );

			if ( $owner_role_meta === 'yes' ) {
				$default_role = 'owner';
			}
		}

		return $default_role;
	}

	add_filter( 'urbango_membership_default_role', 'urbango_listing_user_set_registration_role' );
}

if ( ! function_exists( 'urbango_listing_adjust_woo_settings' ) ) {
	function urbango_listing_adjust_woo_settings() {
		update_option( 'woocommerce_enable_guest_checkout', 'no' );
	}
	
	add_action( 'woocommerce_installed', 'urbango_listing_adjust_woo_settings' );
}
