<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_roles_options_map' ) ) {
	function urbango_listing_roles_options_map( $panel ) {
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_registration_role_enabled',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Registration Role', 'urbango-listing' ),
				'description'   => esc_html__( 'Enable this if you want to allow users to choose role upon registration. Otherwise, default role from WP Settings -> General will be used.', 'urbango-listing' ),
				'parent'        => $panel
			)
		);
		
		$role_settings_container = urbango_edge_add_admin_container(
			array(
				'name'       => 'role_settings_container',
				'type'       => 'container',
				'parent'     => $panel,
				'dependency' => array(
					'show' => array(
						'listing_registration_role_enabled' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_enable_owner_role',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Owner Role', 'urbango-listing' ),
				'parent'        => $role_settings_container
			)
		);
		
		$owner_container = urbango_edge_add_admin_container(
			array(
				'name'       => 'owner_container',
				'type'       => 'container',
				'parent'     => $role_settings_container,
				'dependency' => array(
					'show' => array(
						'listing_enable_owner_role' => 'yes'
					)
				)
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_owner_adding_listing_item',
				'type'          => 'yesno',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Enable Adding Listing Item for Owner', 'urbango-listing' ),
				'parent'        => $owner_container
			)
		);
		
		urbango_edge_add_admin_field(
			array(
				'name'          => 'listing_enable_publish_from_user',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Enable Publishing Listing Items for Users', 'urbango-listing' ),
				'parent'        => $role_settings_container
			)
		);
	}
	
	add_action( 'urbango_listing_action_additional_package_options_map', 'urbango_listing_roles_options_map' );
}
