<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

?>
<div class="edgtf-enquiry-holder">
    <div class="edgtf-enquiry-inner">
        <a class="edgtf-enquiry-close" href="#">
			<?php echo urbango_edge_icon_collections()->renderIcon( 'icon_close', 'font_elegant' ); ?>
        </a>
        <form class="edgtf-enquiry-form" method="POST">
            <h5 class="edgtf-enquiry-title">
                <span class="edgtf-enquiry-title-label"><?php esc_html_e( 'Contact', 'urbango-listing' ); ?></span>
            </h5>
            <input type="text" name="edgtf_enquiry_name" id="edgtf-enquiry-name" value="" placeholder="<?php esc_attr_e( 'Your Full Name', 'urbango-listing' ); ?>" required pattern=".{6,}"/>
            <input type="email" name="edgtf_enquiry_email" id="edgtf-enquiry-email" value="" placeholder="<?php esc_attr_e( 'Your E-mail', 'urbango-listing' ); ?>" required pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,3}$"/>
            <textarea name="edgtf_enquiry_message" id="edgtf-enquiry-message" placeholder="<?php esc_attr_e( 'Your Message', 'urbango-listing' ); ?>" required></textarea>

			<?php if ( urbango_listing_is_core_plugin_installed() ) {
				echo urbango_edge_get_button_html( array(
					'custom_class' => 'edgtf-enquiry-submit',
					'html_type'    => 'button',
					'text'         => esc_html__( 'Send Your Message', 'urbango-listing' )
				) );
			} ?>

            <input type="hidden" id="edgtf-enquiry-item-id" value="<?php the_ID(); ?>">

			<?php wp_nonce_field( 'urbango_listing_validate_listing_item_enquiry_form', 'urbango_listing_nonce_listing_item_enquiry_form' ); ?>
        </form>
        <div class="edgtf-enquiry-response"></div>
    </div>
</div>