<?php

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'urbango_listing_get_listing_item_enquiry_form' ) ) {
	function urbango_listing_get_listing_item_enquiry_form() {
		$allowed_pages = apply_filters( 'urbango_listing_filter_allowed_enquiry_pages', array() );
		
		if ( ! empty( $allowed_pages ) && get_post_meta( get_the_ID(), 'edgtf_listing_enable_enquiry_form_meta', true ) === 'yes' ) {
			foreach ( $allowed_pages as $allowed_page ) {
				if ( is_singular( $allowed_page ) ) {
					urbango_listing_get_module_template_part( 'modules', 'enquiry', 'templates/enquiry-form' );
				}
			}
		}
	}
	
	add_action( 'urbango_edge_action_before_page_header', 'urbango_listing_get_listing_item_enquiry_form' );
}

if ( ! function_exists( 'urbango_listing_send_listing_item_enquiry' ) ) {
	function urbango_listing_send_listing_item_enquiry() {
		if ( isset( $_POST['enquiryData'] ) ) {
			$error           = false;
			$responseMessage = '';
			
			$email_data = $_POST['enquiryData'];
			$nonce      = $email_data['nonce'];
			
			if ( wp_verify_nonce( $nonce, 'urbango_listing_validate_listing_item_enquiry_form' ) ) {
				
				// Validate input fields
				if ( ! empty( $email_data['name'] ) ) {
					$name = esc_attr( esc_html( $email_data['name'] ) );
				} else {
					$error           = true;
					$responseMessage = esc_html__( 'Please enter a valid name.', 'urbango-listing' );
				}
				
				if ( ! empty( $email_data['email'] ) ) {
					$email = sanitize_email( $email_data['email'] );
				} else {
					$error           = true;
					$responseMessage = esc_html__( 'Please enter a valid email.', 'urbango-listing' );
				}
				
				if ( ! empty( $email_data['message'] ) ) {
					$message = esc_attr( esc_html( $email_data['message'] ) );
				} else {
					$error           = true;
					$responseMessage = esc_html__( 'Please enter a valid message.', 'urbango-listing' );
				}
				
				// Send mail and response
				if ( $error ) {
					urbango_listing_get_ajax_status( 'error', $responseMessage );
				} else {
					// Get post id from request
					$post_id = $email_data['itemID'];
					
					// Get email address from single page meta option
					$mail_to = get_post_meta( $post_id, 'edgtf_listing_single_contact_email_meta', true );
					
					$headers = array(
						'From: ' . $name . ' <' . $email . '>',
						'Reply-To: ' . $name . ' <' . $email . '>',
					);
					
					$messageTemplate = esc_html__( 'From', 'urbango-listing' ) . ': ' . $name . "\r\n";
					$messageTemplate .= esc_html__( 'Email', 'urbango-listing' ) . ': ' . $email . "\r\n";
					$messageTemplate .= esc_html__( 'Message', 'urbango-listing' ) . ': ' . $message . "\r\n\n";
					$messageTemplate .= esc_html__( 'Message sent via enquiry form on', 'urbango-listing' ) . ' ' . esc_attr( get_bloginfo( 'name' ) ) . ' - ' . esc_url( home_url( '/' ) );
					
					wp_mail(
						sanitize_email( $mail_to ), // Mail To
						sprintf( esc_html__( 'New Enquiry From %s', 'urbango-listing' ), $name ), // Subject
						$messageTemplate, // Message
						$headers // Additional Headers
					);
					
					urbango_listing_get_ajax_status( 'success', esc_html__( 'Enquiry is successfully sent.', 'urbango-listing' ) );
					
					unset( $_POST['enquiryData'] ); // Remove data from global post variable after submission
				}
			} else {
				urbango_listing_get_ajax_status( 'error', esc_html__( 'Nonce is invalid.', 'urbango-listing' ) );
			}
		} else {
			urbango_listing_get_ajax_status( 'error', esc_html__( 'Please review your enquiry and send again.', 'urbango-listing' ) );
		}
	}
	
	add_action( 'wp_ajax_nopriv_urbango_listing_send_listing_item_enquiry', 'urbango_listing_send_listing_item_enquiry' );
	add_action( 'wp_ajax_urbango_listing_send_listing_item_enquiry', 'urbango_listing_send_listing_item_enquiry' );
}
