<?php
/*
Plugin Name: UrbanGo Listing
Description: Plugin that adds all custom post types and taxonomies for listing
Author: Edge Themes
Version: 1.3.2
*/

require_once 'const.php';
require_once 'before-load.php';

if ( ! function_exists( 'urbango_listing_load_files' ) ) {
	/**
	 * Load main plugin file on plugins_loaded action
	 */
	function urbango_listing_load_files() {
		require_once 'load.php';
	}

	add_action( 'plugins_loaded', 'urbango_listing_load_files' );
}

if ( ! function_exists( 'urbango_listing_activation_plugin_hook' ) ) {
	/**
	 * Triggers when plugin is activated. It calls flush_rewrite_rules
	 * and defines urbango_listing_action_activation_plugin action
	 */
	function urbango_listing_activation_plugin_hook() {
		do_action( 'urbango_listing_action_activation_plugin' );
	}

	register_activation_hook( __FILE__, 'urbango_listing_activation_plugin_hook' );
}

if ( ! function_exists( 'urbango_listing_deactivation_plugin_hook' ) ) {
	/**
	 * Triggers when plugin is activated. It calls flush_rewrite_rules
	 * and defines urbango_listing_action_deactivation_plugin action
	 */
	function urbango_listing_deactivation_plugin_hook() {
		do_action( 'urbango_listing_action_deactivation_plugin' );
	}

	register_deactivation_hook( __FILE__, 'urbango_listing_deactivation_plugin_hook' );
}

if ( ! function_exists( 'urbango_listing_text_domain' ) ) {
	/**
	 * Loads plugin text domain so it can be used in translation
	 */
	function urbango_listing_text_domain() {
		load_plugin_textdomain( 'urbango-listing', false, URBANGO_LISTING_REL_PATH . '/languages' );
	}

	add_action( 'plugins_loaded', 'urbango_listing_text_domain' );
}

if ( ! function_exists( 'urbango_listing_load_assets' ) ) {
	/**
	 * Loads plugin assets
	 */
	function urbango_listing_load_assets() {
		$array_deps_css            = array();
		$array_deps_css_responsive = array();
		$array_deps_js             = array();

		if ( urbango_listing_is_theme_installed() ) {
			$array_deps_css[]            = 'urbango-edge-modules';
			$array_deps_css_responsive[] = 'urbango-edge-modules-responsive';

			$array_deps_js[] = 'underscore';
			$array_deps_js[] = 'urbango-edge-modules';
			$array_deps_js[] = 'urbango-edge-google-map-api';
		}

		// Include main plugin style
		wp_enqueue_style( 'urbango-listing-style', URBANGO_LISTING_ASSETS_URL_PATH . '/css/listing.min.css', $array_deps_css );

		// Include main plugin responsive style
		if ( function_exists( 'urbango_edge_is_responsive_on' ) && urbango_edge_is_responsive_on() ) {
			wp_enqueue_style( 'urbango-listing-responsive-style', URBANGO_LISTING_ASSETS_URL_PATH . '/css/listing-responsive.min.css', $array_deps_css_responsive );
		}

		// Include 3rd party JavaScripts
		wp_enqueue_script( 'jquery-nouislider', URBANGO_LISTING_ASSETS_URL_PATH . '/js/plugins/noUiSlider/nouislider.min.js', array(), false, true );

		//if ( urbango_listing_is_woocommerce_installed() ) {
		//	wp_enqueue_script( 'select2' );
		//} else {
		wp_enqueue_script( 'select-2', URBANGO_LISTING_ASSETS_URL_PATH . '/js/plugins/select2/select2.full.min.js', array(), false, true );
		//}

		// Include main plugin script
		wp_enqueue_script( 'urbango-listing-script', URBANGO_LISTING_ASSETS_URL_PATH . '/js/listing.min.js', $array_deps_js, false, true );
	}

	add_action( 'wp_enqueue_scripts', 'urbango_listing_load_assets' );
}

if ( ! function_exists( 'urbango_listing_load_admin_page_styles' ) ) {
	function urbango_listing_load_admin_page_styles() {

		// Include main plugin admin style
		wp_enqueue_style( 'urbango-listing-admin-styles', URBANGO_LISTING_ASSETS_URL_PATH . '/css/admin/admin.css' );
	}

	add_action( 'urbango_edge_action_admin_scripts_init', 'urbango_listing_load_admin_page_styles' );
}

if ( ! function_exists( 'urbango_listing_load_admin_page_meta_boxes_styles' ) ) {
	function urbango_listing_load_admin_page_meta_boxes_styles() {

		if ( function_exists( 'get_current_screen' ) ) {
			$current_page = get_current_screen();

			if ( isset( $current_page ) && isset( $current_page->id ) && $current_page->id === 'listing-item' ) {
				// Include main plugin admin meta boxes style
				wp_enqueue_style( 'urbango-listing-admin-meta-boxes-styles', URBANGO_LISTING_ASSETS_URL_PATH . '/css/admin/admin-meta-boxes.css' );
			}
		}
	}

	add_action( 'urbango_edge_action_enqueue_meta_box_styles', 'urbango_listing_load_admin_page_meta_boxes_styles' );
}

if ( ! function_exists( 'urbango_listing_load_admin_page_scripts' ) ) {
	function urbango_listing_load_admin_page_scripts() {

		if ( function_exists( 'get_current_screen' ) ) {
			$current_page = get_current_screen();

			if ( isset( $current_page ) && isset( $current_page->id ) && $current_page->id === 'listing-item' ) {
				// Include main plugin admin script
				wp_enqueue_script( 'urbango-listing-admin-script', URBANGO_LISTING_ASSETS_URL_PATH . '/js/admin/admin.js', array(), false, true );
			}
		}
	}

	add_action( 'urbango_edge_action_enqueue_meta_box_scripts', 'urbango_listing_load_admin_page_scripts' );
}

if ( ! function_exists( 'urbango_listing_is_theme_installed' ) ) {
	/**
	 * Function that checks if theme installed
	 *
	 * @return bool
	 */
	function urbango_listing_is_theme_installed() {
		return defined( 'EDGE_ROOT' );
	}
}

if ( ! function_exists( 'urbango_listing_is_core_plugin_installed' ) ) {
	/**
	 * Function that checks if UrbanGo Core plugin installed
	 *
	 * @return bool
	 */
	function urbango_listing_is_core_plugin_installed() {
		return defined( 'URBANGO_CORE_VERSION' );
	}
}

if ( ! function_exists( 'urbango_listing_is_membership_plugin_installed' ) ) {
	/**
	 * Function that checks if UrbanGo Membership plugin installed
	 *
	 * @return bool
	 */
	function urbango_listing_is_membership_plugin_installed() {
		return defined( 'URBANGO_MEMBERSHIP_VERSION' );
	}
}

if ( ! function_exists( 'urbango_listing_is_woocommerce_checkout_integration_installed' ) ) {
	/**
	 * Function that checks if UrbanGo Woocommerce Checkout integration plugin installed
	 *
	 * @return bool
	 */
	function urbango_listing_is_woocommerce_checkout_integration_installed() {
		return defined( 'URBANGO_CHECKOUT_INTEGRATION' );
	}
}

if ( ! function_exists( 'urbango_listing_is_woocommerce_installed' ) ) {
	/**
	 * Function that checks if Woocommerce plugin installed
	 *
	 * @return bool
	 */
	function urbango_listing_is_woocommerce_installed() {
		return function_exists( 'is_woocommerce' );
	}
}
